/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots.commands.subcommands;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;

@CommandAlias(value="plot|p")
public class PlotTeleportCommand
extends BaseCommand {
    @Subcommand(value="tp|teleport")
    @CommandPermission(value="openminetopia.plot.tp")
    @Syntax(value="<naam>")
    @CommandCompletion(value="@plotName")
    @Description(value="Teleporteer naar een plot.")
    public void tpCommand(Player player, String name) {
        World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        RegionContainer regionContainer = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager regionManager = regionContainer.get(world);
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (regionManager == null) {
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<red>Kon geen regio's ophalen voor deze wereld."));
            return;
        }
        ProtectedRegion region = regionManager.getRegion(name);
        if (region == null) {
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<red>Geen region gevonden met de naam " + name + "."));
            return;
        }
        BlockVector3 center = region.getMaximumPoint().subtract(region.getMinimumPoint()).divide(2).add(region.getMinimumPoint());
        Location location = new Location(player.getWorld(), (double)center.x(), (double)center.y(), (double)center.z());
        player.teleport(location);
        player.sendMessage(ChatUtils.format(minetopiaPlayer, "<dark_aqua>Je bent naar plot <aqua>" + region.getId() + " <dark_aqua>geteleporteerd."));
    }
}

