/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.utils.config.ConfigurateConfig;
import org.bukkit.Material;

public class PlotCalculateConfiguration
extends ConfigurateConfig {
    private final int buildersWage;
    private final String calculateFormula;
    private final Map<Material, Double> blockValues = new HashMap<Material, Double>();

    public PlotCalculateConfiguration(File file) {
        super(file, "plotcalculate.yml", "default/plotcalculate.yml", false);
        this.buildersWage = this.rootNode.node(new Object[]{"builders-wage"}).getInt(20);
        this.calculateFormula = this.rootNode.node(new Object[]{"plot-calculate-formula"}).getString("<length> * <width> * 32");
        this.rootNode.node(new Object[]{"block-prices"}).childrenMap().forEach((key, value) -> {
            if (!(key instanceof String)) {
                return;
            }
            String materialName = (String)key;
            Material material = Material.matchMaterial((String)materialName);
            if (material == null) {
                OpenMinetopia.getInstance().getLogger().warning("Invalid material in plotcalculate.yml: " + String.valueOf(key));
                return;
            }
            double valueDouble = value.getDouble(0.0);
            this.blockValues.put(material, valueDouble);
        });
    }

    @Generated
    public int getBuildersWage() {
        return this.buildersWage;
    }

    @Generated
    public String getCalculateFormula() {
        return this.calculateFormula;
    }

    @Generated
    public Map<Material, Double> getBlockValues() {
        return this.blockValues;
    }
}

