/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.police;

import com.craftmend.storm.api.enums.Where;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.data.utils.StormUtils;
import nl.openminetopia.modules.player.models.PlayerModel;
import nl.openminetopia.modules.police.commands.BodysearchCommand;
import nl.openminetopia.modules.police.commands.CriminalRecordCommand;
import nl.openminetopia.modules.police.commands.EmergencyCommand;
import nl.openminetopia.modules.police.handcuff.HandcuffManager;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerDropItemListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerEntityDamageListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerHandcuffListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerInventoryClickListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerMoveListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerOpenInventoryListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerPickupItemListener;
import nl.openminetopia.modules.police.handcuff.listeners.PlayerSlotChangeListener;
import nl.openminetopia.modules.police.handcuff.objects.HandcuffedPlayer;
import nl.openminetopia.modules.police.listeners.PlayerArmorChangeListener;
import nl.openminetopia.modules.police.listeners.PlayerPeppersprayListener;
import nl.openminetopia.modules.police.listeners.PlayerTaserListener;
import nl.openminetopia.modules.police.models.CriminalRecordModel;
import nl.openminetopia.modules.police.taser.TaserManager;
import nl.openminetopia.modules.police.walkietalkie.WalkieTalkieManager;
import nl.openminetopia.modules.police.walkietalkie.listeners.PlayerChatListener;
import nl.openminetopia.modules.police.walkietalkie.listeners.PlayerInteractListener;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class PoliceModule
extends ExtendedSpigotModule {
    private final HashMap<UUID, Long> emergencyCooldowns = new HashMap();
    private WalkieTalkieManager walkieTalkieManager;
    private TaserManager taserManager;

    public PoliceModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.walkieTalkieManager = new WalkieTalkieManager();
        this.taserManager = new TaserManager();
        this.registerComponent(new EmergencyCommand());
        this.registerComponent(new CriminalRecordCommand());
        this.registerComponent(new BodysearchCommand());
        this.registerComponent(new PlayerArmorChangeListener());
        this.registerComponent(new PlayerHandcuffListener());
        this.registerComponent(new PlayerMoveListener());
        this.registerComponent(new PlayerDropItemListener());
        this.registerComponent(new PlayerEntityDamageListener());
        this.registerComponent(new PlayerOpenInventoryListener());
        this.registerComponent(new PlayerPickupItemListener());
        this.registerComponent(new PlayerSlotChangeListener());
        this.registerComponent(new PlayerInventoryClickListener());
        this.registerComponent(new PlayerChatListener());
        this.registerComponent(new PlayerInteractListener());
        this.registerComponent(new PlayerPeppersprayListener());
        this.registerComponent(new PlayerTaserListener());
    }

    @Override
    public void onDisable() {
        HandcuffManager.getInstance().getHandcuffedPlayers().forEach(HandcuffedPlayer::release);
    }

    public CompletableFuture<Integer> addCriminalRecord(PlayerModel playerModel, String description, UUID officerUuid, Long date) {
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        StormDatabase.getExecutorService().submit(() -> {
            CriminalRecordModel criminalRecordModel = new CriminalRecordModel();
            criminalRecordModel.setPlayerId(playerModel.getId());
            criminalRecordModel.setDescription(description);
            criminalRecordModel.setOfficerId(officerUuid);
            criminalRecordModel.setDate(date);
            playerModel.getCriminalRecords().add(criminalRecordModel);
            int id = StormDatabase.getInstance().saveStormModel(criminalRecordModel).join();
            completableFuture.complete(id);
        });
        return completableFuture;
    }

    public CompletableFuture<Void> removeCriminalRecord(PlayerModel playerModel, CriminalRecordModel criminalRecordModel) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        StormDatabase.getExecutorService().submit(() -> {
            playerModel.getCriminalRecords().remove(criminalRecordModel);
            StormUtils.deleteModelData(CriminalRecordModel.class, query -> query.where("id", Where.EQUAL, criminalRecordModel.getId()));
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    @Generated
    public HashMap<UUID, Long> getEmergencyCooldowns() {
        return this.emergencyCooldowns;
    }

    @Generated
    public WalkieTalkieManager getWalkieTalkieManager() {
        return this.walkieTalkieManager;
    }

    @Generated
    public TaserManager getTaserManager() {
        return this.taserManager;
    }
}

