/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.police.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.police.models.CriminalRecordModel;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.CommandHelp;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.HelpCommand;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="criminalrecord|strafblad")
public class CriminalRecordCommand
extends BaseCommand {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat(MessageConfiguration.message("police_criminal_record_date_format"));

    @HelpCommand
    public void onHelp(CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="add")
    @Description(value="Add a criminal record to a player")
    @Syntax(value="<player> <description>")
    @CommandCompletion(value="@players")
    @CommandPermission(value="openminetopia.criminalrecord.add")
    public void add(Player player, OfflinePlayer target, String description) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (target == null) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
            return;
        }
        PlayerManager.getInstance().getMinetopiaPlayer(target).whenComplete((targetMinetopiaPlayer, throwable1) -> {
            if (targetMinetopiaPlayer == null) {
                return;
            }
            targetMinetopiaPlayer.addCriminalRecord(description, player.getUniqueId(), System.currentTimeMillis());
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("police_criminal_record_added").replace("<player>", target.getName() == null ? "Onbekend" : target.getName()).replace("<description>", description));
        });
    }

    @Subcommand(value="remove")
    @Description(value="Remove a criminal record from a player")
    @Syntax(value="<player> <id>")
    @CommandCompletion(value="@players")
    @CommandPermission(value="openminetopia.criminalrecord.remove")
    public void remove(Player player, OfflinePlayer target, int id) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (target == null) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
            return;
        }
        PlayerManager.getInstance().getMinetopiaPlayer(target).whenComplete((targetMinetopiaPlayer, throwable1) -> {
            if (targetMinetopiaPlayer == null) {
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                return;
            }
            for (CriminalRecordModel criminalRecord : targetMinetopiaPlayer.getCriminalRecords()) {
                if (criminalRecord.getId() != id) continue;
                targetMinetopiaPlayer.removeCriminalRecord(criminalRecord);
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("police_criminal_record_removed").replace("<player>", target.getName() == null ? "Onbekend" : target.getName()).replace("<description>", criminalRecord.getDescription()).replace("<id>", String.valueOf(id)));
                return;
            }
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("police_criminal_record_not_found"));
        });
    }

    @Subcommand(value="info")
    @Description(value="View the criminal records of a player")
    @Syntax(value="<player>")
    @CommandCompletion(value="@players")
    @CommandPermission(value="openminetopia.criminalrecord.info")
    public void info(Player player, OfflinePlayer target) {
        PlayerManager.getInstance().getMinetopiaPlayer((OfflinePlayer)player).whenComplete((minetopiaPlayer, throwable) -> {
            if (minetopiaPlayer == null) {
                return;
            }
            if (target == null) {
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                return;
            }
            PlayerManager.getInstance().getMinetopiaPlayer(target).whenComplete((targetMinetopiaPlayer, throwable1) -> {
                if (targetMinetopiaPlayer == null) {
                    ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                    return;
                }
                if (targetMinetopiaPlayer.getCriminalRecords().isEmpty()) {
                    ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("police_criminal_record_none").replace("<player>", target.getName() == null ? "Onbekend" : target.getName()));
                    return;
                }
                targetMinetopiaPlayer.getCriminalRecords().forEach(criminalRecord -> {
                    OfflinePlayer officer = Bukkit.getOfflinePlayer((UUID)criminalRecord.getOfficerId());
                    ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("police_criminal_record_info_entry").replace("<id>", String.valueOf(criminalRecord.getId())).replace("<description>", criminalRecord.getDescription()).replace("<officer>", officer.getName() == null ? "Onbekend" : officer.getName()).replace("<date>", this.formatDate(criminalRecord.getDate())));
                });
            });
        });
    }

    private String formatDate(long date) {
        return this.dateFormat.format(new Date(date));
    }
}

