/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.police.commands;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.police.PoliceModule;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.Default;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="112|911")
public class EmergencyCommand
extends BaseCommand {
    @Default
    public void emergency(CommandSender sender, String message) {
        if (!(sender instanceof Player)) {
            this.broadcastEmergency(message, sender);
            return;
        }
        Player player = (Player)sender;
        if (this.hasCooldown(player)) {
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
            long cooldown = OpenMinetopia.getModuleManager().get(PoliceModule.class).getEmergencyCooldowns().get(player.getUniqueId());
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("emergency_too_soon"));
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("emergency_cooldown").replace("<time>", this.cooldownToTime(cooldown)));
            return;
        }
        OpenMinetopia.getModuleManager().get(PoliceModule.class).getEmergencyCooldowns().put(player.getUniqueId(), System.currentTimeMillis());
        this.broadcastEmergency(message, sender);
    }

    private void broadcastEmergency(String message, CommandSender sender) {
        boolean isPlayer = sender instanceof Player;
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (!onlinePlayer.hasPermission("openminetopia.police")) {
                return;
            }
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(onlinePlayer);
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("emergency_format").replace("<sender>", isPlayer ? sender.getName() : "Anoniem").replace("<x>", isPlayer ? this.getX(sender) : "").replace("<y>", isPlayer ? this.getY(sender) : "").replace("<z>", isPlayer ? this.getZ(sender) : "").replace("<world>", isPlayer ? this.getWorld(sender) : "Onbekend").replace("<message>", message));
        }
    }

    private String getX(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return "";
        }
        Player player = (Player)sender;
        return "" + player.getLocation().getBlockX();
    }

    private String getY(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return "";
        }
        Player player = (Player)sender;
        return "" + player.getLocation().getBlockY();
    }

    private String getZ(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return "";
        }
        Player player = (Player)sender;
        return "" + player.getLocation().getBlockZ();
    }

    private String getWorld(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return "";
        }
        Player player = (Player)sender;
        return player.getWorld().getName();
    }

    private boolean hasCooldown(Player player) {
        PoliceModule policeModule = OpenMinetopia.getModuleManager().get(PoliceModule.class);
        if (!policeModule.getEmergencyCooldowns().containsKey(player.getUniqueId())) {
            return false;
        }
        long cooldown = policeModule.getEmergencyCooldowns().get(player.getUniqueId());
        if (System.currentTimeMillis() - cooldown >= (long)OpenMinetopia.getDefaultConfiguration().getEmergencyCooldown() * 1000L) {
            policeModule.getEmergencyCooldowns().remove(player.getUniqueId());
            return false;
        }
        return true;
    }

    private String cooldownToTime(long cooldown) {
        long millis = (long)OpenMinetopia.getDefaultConfiguration().getEmergencyCooldown() * 1000L - (System.currentTimeMillis() - cooldown);
        long seconds = this.millisToSeconds(millis);
        long minutes = this.millisToMinutes(millis);
        return minutes + " minuten en " + seconds + " seconden";
    }

    private long millisToSeconds(long millis) {
        return millis / 1000L;
    }

    private long millisToMinutes(long millis) {
        return millis / 60000L;
    }
}

