/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.police.handcuff;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.police.handcuff.objects.HandcuffedPlayer;
import org.bukkit.entity.Player;

public class HandcuffManager {
    private static final HandcuffManager instance = new HandcuffManager();
    public List<HandcuffedPlayer> handcuffedPlayers = new ArrayList<HandcuffedPlayer>();

    public void handcuff(MinetopiaPlayer targetMinetopiaPlayer, MinetopiaPlayer sourceMinetopiaPlayer) {
        Player target = targetMinetopiaPlayer.getBukkit().getPlayer();
        if (target == null) {
            return;
        }
        Player source = sourceMinetopiaPlayer.getBukkit().getPlayer();
        if (source == null) {
            return;
        }
        HandcuffedPlayer handcuffedPlayer = new HandcuffedPlayer(source, target);
        this.handcuffedPlayers.add(handcuffedPlayer);
        handcuffedPlayer.handcuff();
    }

    public void release(HandcuffedPlayer handcuffedPlayer) {
        handcuffedPlayer.release();
        this.handcuffedPlayers.remove(handcuffedPlayer);
    }

    public boolean isHandcuffed(Player player) {
        return this.handcuffedPlayers.stream().anyMatch(handcuffedPlayer -> handcuffedPlayer.getPlayer().equals((Object)player));
    }

    public boolean isHandcuffing(Player player) {
        return this.handcuffedPlayers.stream().anyMatch(handcuffedPlayer -> handcuffedPlayer.getSource().equals((Object)player));
    }

    public HandcuffedPlayer getHandcuffedPlayer(Player player) {
        return this.handcuffedPlayers.stream().filter(handcuffedPlayer -> handcuffedPlayer.getPlayer().equals((Object)player)).findFirst().orElse(null);
    }

    @Generated
    public static HandcuffManager getInstance() {
        return instance;
    }

    @Generated
    public List<HandcuffedPlayer> getHandcuffedPlayers() {
        return this.handcuffedPlayers;
    }
}

