/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.portal.commands;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.WebClient;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.portal.PortalModule;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.Default;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.entity.Player;
import org.json.simple.JSONObject;

@CommandAlias(value="koppel|link")
public class LinkCommand
extends BaseCommand {
    @Default
    public void verify(Player player, String token) {
        this.verifyPlayer(player, token);
    }

    private void verifyPlayer(Player player, String token) {
        JSONObject requestBody = new JSONObject();
        requestBody.put((Object)"token", (Object)token);
        requestBody.put((Object)"minecraft_username", (Object)player.getName());
        requestBody.put((Object)"minecraft_uuid", (Object)player.getUniqueId().toString());
        PortalModule portalModule = OpenMinetopia.getModuleManager().get(PortalModule.class);
        WebClient webClient = WebClient.create((Vertx)OpenMinetopia.getInstance().getOrCreateVertx());
        webClient.postAbs(portalModule.getPortalApiUrl() + "/minecraft/verify").putHeader("Content-Type", "application/json").putHeader("X-API-Key", OpenMinetopia.getDefaultConfiguration().getPortalToken()).sendBuffer(Buffer.buffer((String)requestBody.toString())).onSuccess(response -> {
            if (response.statusCode() != 200) {
                ChatUtils.sendMessage(player, "<red>Er is iets fout gegaan bij het verifi\u00ebren van je account.");
                OpenMinetopia.getInstance().getLogger().warning("Response code " + response.statusCode() + " " + response.statusMessage() + " while trying to verify player " + player.getName());
                return;
            }
            ChatUtils.sendMessage(player, "<green>Je account is succesvol gekoppeld!");
        }).onFailure(err -> {
            ChatUtils.sendMessage(player, "<red>Er is iets fout gegaan bij het verifi\u00ebren van je account.");
            OpenMinetopia.getInstance().getLogger().severe("An error occurred while trying to verify player " + player.getName() + ": " + err.getMessage());
        });
    }
}

