/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.prefix.commands.subcommands;

import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.player.utils.PlaytimeUtil;
import nl.openminetopia.modules.prefix.objects.Prefix;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="prefix")
public class PrefixAddCommand
extends BaseCommand {
    @Subcommand(value="add")
    @Syntax(value="<speler> <minuten> <prefix>")
    @CommandCompletion(value="@players @range:0-1440 @nothing")
    @CommandPermission(value="openminetopia.prefix.add")
    @Description(value="Voeg een prefix toe aan een speler voor een bepaalde tijd.")
    public void addPrefix(Player player, OfflinePlayer offlinePlayer, Integer expiresAt, String prefix) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (offlinePlayer == null) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
            return;
        }
        PlayerManager.getInstance().getMinetopiaPlayer(offlinePlayer).whenComplete((targetMinetopiaPlayer, throwable1) -> {
            if (targetMinetopiaPlayer == null) {
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                return;
            }
            for (Prefix prefix1 : targetMinetopiaPlayer.getPrefixes()) {
                if (!prefix1.getPrefix().equalsIgnoreCase(prefix)) continue;
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("prefix_already_exists").replace("<player>", offlinePlayer.getName() == null ? "null" : offlinePlayer.getName()).replace("<prefix>", prefix));
                return;
            }
            long expiresAtMillis = System.currentTimeMillis() + this.minutesToMillis(expiresAt);
            if (expiresAt == -1) {
                expiresAtMillis = -1L;
            }
            Prefix prefixModel = new Prefix(prefix, expiresAtMillis);
            targetMinetopiaPlayer.addPrefix(prefixModel);
            targetMinetopiaPlayer.setActivePrefix(prefixModel);
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("prefix_added").replace("<player>", offlinePlayer.getName() == null ? "null" : offlinePlayer.getName()).replace("<prefix>", prefix).replace("<time>", expiresAt == -1 ? "nooit" : PlaytimeUtil.formatPlaytime(this.minutesToMillis(expiresAt))));
        });
    }

    private long minutesToMillis(int minutes) {
        return (long)(minutes * 60) * 1000L;
    }
}

