/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.prefix.commands.subcommands;

import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.prefix.objects.Prefix;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="prefix")
public class PrefixRemoveCommand
extends BaseCommand {
    @Subcommand(value="remove")
    @Syntax(value="<player> <prefix>")
    @CommandPermission(value="openminetopia.prefix.remove")
    @CommandCompletion(value="@players @playerPrefixes")
    @Description(value="Verwijder een prefix van een speler.")
    public void removePrefix(Player player, OfflinePlayer offlinePlayer, String prefixName) {
        PlayerManager.getInstance().getMinetopiaPlayer((OfflinePlayer)player).whenComplete((minetopiaPlayer, throwable) -> {
            if (minetopiaPlayer == null) {
                return;
            }
            if (offlinePlayer == null) {
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                return;
            }
            PlayerManager.getInstance().getMinetopiaPlayer(offlinePlayer).whenComplete((targetMinetopiaPlayer, throwable1) -> {
                if (targetMinetopiaPlayer == null) {
                    ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                    return;
                }
                for (Prefix prefix : targetMinetopiaPlayer.getPrefixes()) {
                    if (!prefix.getPrefix().equalsIgnoreCase(prefixName)) continue;
                    ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("prefix_removed").replace("<player>", offlinePlayer.getName() == null ? "null" : offlinePlayer.getName()).replace("<prefix>", prefix.getPrefix()));
                    targetMinetopiaPlayer.removePrefix(prefix);
                    return;
                }
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("prefix_not_found").replace("<player>", offlinePlayer.getName() == null ? "null" : offlinePlayer.getName()).replace("<prefix>", prefixName));
            });
        });
    }
}

