/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.prefix.menus;

import java.util.ArrayList;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.prefix.events.PlayerChangePrefixEvent;
import nl.openminetopia.modules.prefix.objects.Prefix;
import nl.openminetopia.shaded.gui.guis.GuiItem;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.events.EventUtils;
import nl.openminetopia.utils.item.ItemBuilder;
import nl.openminetopia.utils.menu.PaginatedMenu;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PrefixMenu
extends PaginatedMenu {
    public PrefixMenu(Player player, OfflinePlayer offlinePlayer, MinetopiaPlayer minetopiaPlayer) {
        super("<black>Kies een prefix", 2, 9);
        this.gui.disableAllInteractions();
        if (minetopiaPlayer == null) {
            return;
        }
        ArrayList<Prefix> prefixes = new ArrayList<Prefix>(minetopiaPlayer.getPrefixes());
        if (minetopiaPlayer.getActivePrefix() != null && minetopiaPlayer.getActivePrefix().getId() != -1) {
            prefixes.add(new Prefix(-1, OpenMinetopia.getDefaultConfiguration().getDefaultPrefix(), -1L));
        }
        prefixes.removeIf(prefix -> prefix.getId() == minetopiaPlayer.getActivePrefix().getId());
        this.gui.setItem(12, this.previousPageItem());
        this.gui.setItem(14, this.nextPageItem());
        GuiItem selectedPrefixItem = new GuiItem(new ItemBuilder(Material.NAME_TAG).setName("<white>" + minetopiaPlayer.getActivePrefix().getPrefix()).addLoreLine("").addLoreLine("<gold>Je hebt deze prefix geselecteerd.").setGlowing(true).toItemStack(), event -> event.setCancelled(true));
        this.gui.addItem(selectedPrefixItem);
        for (Prefix prefix2 : prefixes) {
            ItemBuilder builder = new ItemBuilder(Material.PAPER).setName("<white>" + prefix2.getPrefix()).addLoreLine("").addLoreLine("<gold>Klik <yellow>hier <gold>om deze prefix te selecteren.").addLoreLine("");
            if (prefix2.getExpiresAt() != -1L && prefix2.getExpiresAt() - System.currentTimeMillis() < -1L) {
                builder.addLoreLine("<red>Deze prefix is vervallen.");
            }
            if (prefix2.getExpiresAt() != -1L && prefix2.getExpiresAt() - System.currentTimeMillis() > -1L) {
                builder.addLoreLine("<gold>Deze prefix vervalt over <yellow>" + this.millisToTime(prefix2.getExpiresAt() - System.currentTimeMillis()) + "<gold>.");
            }
            if (prefix2.getExpiresAt() == -1L) {
                builder.addLoreLine("<gold>Deze prefix vervalt <yellow>nooit<gold>.");
            }
            GuiItem prefixItem = new GuiItem(builder.toItemStack(), event -> {
                event.setCancelled(true);
                Prefix toSet = prefix2.getId() == -1 ? new Prefix(-1, OpenMinetopia.getDefaultConfiguration().getDefaultPrefix(), -1L) : prefix2;
                PlayerChangePrefixEvent changePrefixEvent = new PlayerChangePrefixEvent(player, toSet);
                if (EventUtils.callCancellable(changePrefixEvent)) {
                    return;
                }
                minetopiaPlayer.setActivePrefix(toSet);
                player.sendMessage(ChatUtils.format(minetopiaPlayer, "<gold>Je hebt de prefix <yellow>" + prefix2.getPrefix() + " <gold>geselecteerd."));
                new PrefixMenu(player, offlinePlayer, minetopiaPlayer).open(player);
            });
            this.gui.addItem(prefixItem);
        }
    }

    private String millisToTime(long millis) {
        long totalSeconds = millis / 1000L;
        long totalMinutes = totalSeconds / 60L;
        long totalHours = totalMinutes / 60L;
        long days = totalHours / 24L;
        long hours = totalHours % 24L;
        long minutes = totalMinutes % 60L;
        long seconds = totalSeconds % 60L;
        return MessageConfiguration.message("time_format").replace("<days>", String.valueOf(days)).replace("<hours>", String.valueOf(hours)).replace("<minutes>", String.valueOf(minutes)).replace("<seconds>", String.valueOf(seconds));
    }
}

