/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.restapi.base.VerticleManager;
import nl.openminetopia.modules.restapi.verticles.MainVerticle;
import nl.openminetopia.modules.restapi.verticles.banking.BankAccountUsersVerticle;
import nl.openminetopia.modules.restapi.verticles.banking.BankAccountVerticle;
import nl.openminetopia.modules.restapi.verticles.banking.BankAccountsVerticle;
import nl.openminetopia.modules.restapi.verticles.banking.transactions.BankAccountTransactionVerticle;
import nl.openminetopia.modules.restapi.verticles.banking.transactions.BankAccountTransactionsVerticle;
import nl.openminetopia.modules.restapi.verticles.places.PlacesVerticle;
import nl.openminetopia.modules.restapi.verticles.player.ColorsVerticle;
import nl.openminetopia.modules.restapi.verticles.player.CriminalRecordsVerticle;
import nl.openminetopia.modules.restapi.verticles.player.FitnessStatisticsVerticle;
import nl.openminetopia.modules.restapi.verticles.player.PlayerBankAccountsVerticle;
import nl.openminetopia.modules.restapi.verticles.player.PlayerPlotsVerticle;
import nl.openminetopia.modules.restapi.verticles.player.PlayerVerticle;
import nl.openminetopia.modules.restapi.verticles.player.PrefixesVerticle;
import nl.openminetopia.modules.restapi.verticles.plots.PlotsVerticle;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class RestAPIModule
extends ExtendedSpigotModule {
    public VerticleManager verticleManager;

    public RestAPIModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        if (OpenMinetopia.getDefaultConfiguration().isRestApiEnabled()) {
            Vertx vertx = OpenMinetopia.getInstance().getOrCreateVertx();
            Context context = vertx.getOrCreateContext();
            Router router = Router.router((Vertx)vertx);
            router.route().handler((Handler)BodyHandler.create());
            this.verticleManager = new VerticleManager(vertx, context, router);
            this.verticleManager.register(new MainVerticle(), new PlayerVerticle(), new PrefixesVerticle(), new ColorsVerticle(), new FitnessStatisticsVerticle(), new BankAccountVerticle(), new BankAccountsVerticle(), new BankAccountUsersVerticle(), new PlayerBankAccountsVerticle(), new CriminalRecordsVerticle(), new PlayerPlotsVerticle(), new PlotsVerticle(), new PlacesVerticle(), new BankAccountTransactionsVerticle(), new BankAccountTransactionVerticle());
        }
    }
}

