/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles;

import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.restapi.base.BaseVerticle;

public class MainVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.route().handler(this::validateApiKey);
        this.vertx.createHttpServer().requestHandler((Handler)this.router).listen(OpenMinetopia.getDefaultConfiguration().getRestApiPort(), OpenMinetopia.getDefaultConfiguration().getRestApiHost()).onSuccess(server -> {
            OpenMinetopia.getInstance().getLogger().info("HTTP server started on port " + server.actualPort() + " and host " + OpenMinetopia.getDefaultConfiguration().getRestApiHost());
            startPromise.complete();
        }).onFailure(throwable -> {
            throwable.printStackTrace();
            startPromise.fail(throwable);
        });
    }

    private void validateApiKey(RoutingContext context) {
        String apiKey = context.request().getHeader("X-API-Key");
        if (apiKey == null || !apiKey.equals(OpenMinetopia.getDefaultConfiguration().getRestApiKey())) {
            context.response().setStatusCode(401).end("Unauthorized request");
        } else {
            context.next();
        }
    }
}

