/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.banking;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.json.simple.JSONObject;

public class BankAccountUsersVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/bankaccount/:uuid/users").handler(this::handleGetUsers);
        startPromise.complete();
    }

    private void handleGetUsers(RoutingContext context) {
        JSONObject responseJson = new JSONObject();
        UUID accountUuid = this.parseUuid(context, responseJson);
        if (accountUuid == null) {
            context.response().setStatusCode(400).end(responseJson.toJSONString());
            return;
        }
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        bankingModule.getAccountByIdAsync(accountUuid).whenComplete((account, throwable) -> {
            if (throwable != null) {
                this.handleError(context, responseJson, "Internal server error.", 500);
                return;
            }
            if (account == null) {
                this.handleError(context, responseJson, "Account not found.", 404);
                return;
            }
            JSONObject usersObject = new JSONObject();
            account.getUsers().forEach((userUuid, permission) -> {
                JSONObject userObject = new JSONObject();
                userObject.put((Object)"permission", (Object)permission.name());
                usersObject.put((Object)userUuid.toString(), (Object)userObject);
            });
            responseJson.put((Object)"success", (Object)true);
            responseJson.put((Object)"users", (Object)usersObject);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        });
    }

    private UUID parseUuid(RoutingContext context, JSONObject responseJson) {
        try {
            return UUID.fromString(context.pathParam("uuid"));
        }
        catch (IllegalArgumentException e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)"Invalid UUID format.");
            return null;
        }
    }

    private void handleError(RoutingContext context, JSONObject responseJson, String errorMessage, int statusCode) {
        responseJson.put((Object)"success", (Object)false);
        responseJson.put((Object)"error", (Object)errorMessage);
        context.response().setStatusCode(statusCode).end(responseJson.toJSONString());
    }
}

