/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.banking;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BankAccountsVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/bankaccounts/").handler(this::handleGetBankAccounts);
        startPromise.complete();
    }

    private void handleGetBankAccounts(RoutingContext context) {
        JSONObject responseJson = new JSONObject();
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        bankingModule.getBankAccounts().whenComplete((accounts, throwable) -> {
            if (throwable != null) {
                this.handleError(context, responseJson, "Internal server error.", 500);
                return;
            }
            if (accounts == null || accounts.isEmpty()) {
                this.handleError(context, responseJson, "No accounts found.", 404);
                return;
            }
            JSONArray accountsArray = new JSONArray();
            accounts.forEach(account -> {
                JSONObject accountObject = new JSONObject();
                accountObject.put((Object)"uuid", (Object)account.getUniqueId().toString());
                accountObject.put((Object)"type", (Object)account.getType().name());
                accountObject.put((Object)"name", (Object)account.getName());
                accountObject.put((Object)"frozen", (Object)account.getFrozen());
                accountObject.put((Object)"balance", (Object)account.getBalance());
                accountsArray.add((Object)accountObject);
            });
            responseJson.put((Object)"success", (Object)true);
            responseJson.put((Object)"accounts", (Object)accountsArray);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        });
    }

    private void handleError(RoutingContext context, JSONObject responseJson, String errorMessage, int statusCode) {
        responseJson.put((Object)"success", (Object)false);
        responseJson.put((Object)"error", (Object)errorMessage);
        context.response().setStatusCode(statusCode).end(responseJson.toJSONString());
    }
}

