/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.banking.transactions;

import com.craftmend.storm.api.StormModel;
import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.json.simple.JSONObject;

public class BankAccountTransactionVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.post("/api/bankaccount/:uuid/withdraw").handler(this::handleWithdraw);
        this.router.post("/api/bankaccount/:uuid/deposit").handler(this::handleDeposit);
        startPromise.complete();
    }

    private void handleWithdraw(RoutingContext context) {
        this.processTransaction(context, TransactionType.WITHDRAW);
    }

    private void handleDeposit(RoutingContext context) {
        this.processTransaction(context, TransactionType.DEPOSIT);
    }

    private void processTransaction(RoutingContext context, TransactionType type) {
        JSONObject responseJson = new JSONObject();
        UUID accountUuid = this.parseUuid(context, responseJson);
        if (accountUuid == null) {
            context.response().setStatusCode(400).end(responseJson.toJSONString());
            return;
        }
        Double amount = this.parseAmount(context, responseJson);
        if (amount == null) {
            context.response().setStatusCode(400).end(responseJson.toJSONString());
            return;
        }
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        bankingModule.getAccountByIdAsync(accountUuid).whenComplete((account, throwable) -> {
            if (throwable != null) {
                this.handleError(context, responseJson, "Internal server error.", 500);
                return;
            }
            if (account == null) {
                this.handleError(context, responseJson, "Account not found.", 404);
                return;
            }
            if (type == TransactionType.WITHDRAW && account.getBalance() < amount) {
                this.handleError(context, responseJson, "Insufficient balance.", 400);
                return;
            }
            double updatedBalance = type == TransactionType.WITHDRAW ? account.getBalance() - amount : account.getBalance() + amount;
            account.setBalance(updatedBalance);
            StormDatabase.getInstance().saveStormModel((StormModel)account);
            responseJson.put((Object)"success", (Object)true);
            responseJson.put((Object)"newBalance", (Object)updatedBalance);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        });
    }

    private UUID parseUuid(RoutingContext context, JSONObject responseJson) {
        try {
            return UUID.fromString(context.pathParam("uuid"));
        }
        catch (IllegalArgumentException e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)"Invalid UUID format.");
            return null;
        }
    }

    private Double parseAmount(RoutingContext context, JSONObject responseJson) {
        try {
            double amount = Double.parseDouble(context.body().asJsonObject().getString("amount"));
            if (amount <= 0.0) {
                throw new IllegalArgumentException("Amount must be positive.");
            }
            return amount;
        }
        catch (Exception e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)"Invalid amount.");
            return null;
        }
    }

    private void handleError(RoutingContext context, JSONObject responseJson, String errorMessage, int statusCode) {
        responseJson.put((Object)"success", (Object)false);
        responseJson.put((Object)"error", (Object)errorMessage);
        context.response().setStatusCode(statusCode).end(responseJson.toJSONString());
    }

    private static enum TransactionType {
        WITHDRAW,
        DEPOSIT;

    }
}

