/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.banking.transactions;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.modules.transactions.objects.TransactionModel;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class BankAccountTransactionsVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/bankaccount/:uuid/transactions").handler(this::handleGetBankAccountTransactions);
        startPromise.complete();
    }

    private void handleGetBankAccountTransactions(RoutingContext context) {
        JSONObject responseJson = new JSONObject();
        UUID accountUuid = this.parseUuid(context, responseJson);
        if (accountUuid == null) {
            context.response().setStatusCode(400).end(responseJson.toJSONString());
            return;
        }
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        ((CompletableFuture)bankingModule.getAccountByIdAsync(accountUuid).whenComplete((account, throwable) -> {
            if (throwable != null) {
                this.handleError(context, responseJson, "Internal server error.", 500);
                return;
            }
            if (account == null) {
                this.handleError(context, responseJson, "Account not found.", 404);
                return;
            }
        })).thenCompose(account -> {
            TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);
            return transactionsModule.getAccountTransactions(TransactionsModule.LookupType.BANK_ACCOUNT, account.getUniqueId()).whenComplete((transactionModels, throwable) -> {
                if (throwable != null) {
                    return;
                }
                List<TransactionModel> sortedTransactions = transactionModels.stream().sorted(Comparator.comparing(TransactionModel::getTime).reversed()).toList();
                JSONArray transactionsArray = new JSONArray();
                sortedTransactions.forEach(transaction -> {
                    JSONObject transactionObject = new JSONObject();
                    transactionObject.put((Object)"username", (Object)transaction.getUsername());
                    transactionObject.put((Object)"uuid", (Object)transaction.getPlayer());
                    transactionObject.put((Object)"type", (Object)transaction.getType().name());
                    transactionObject.put((Object)"amount", (Object)transaction.getAmount());
                    transactionObject.put((Object)"time", (Object)transaction.getTime());
                    transactionObject.put((Object)"bank_account", (Object)transaction.getBankAccount());
                    transactionObject.put((Object)"description", (Object)transaction.getDescription());
                    transactionsArray.add((Object)transactionObject);
                });
                responseJson.put((Object)"transactions", (Object)transactionsArray);
                responseJson.put((Object)"success", (Object)true);
                context.response().setStatusCode(200).end(responseJson.toJSONString());
            });
        });
    }

    private UUID parseUuid(RoutingContext context, JSONObject responseJson) {
        try {
            return UUID.fromString(context.pathParam("uuid"));
        }
        catch (IllegalArgumentException e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)"Invalid UUID format.");
            return null;
        }
    }

    private void handleError(RoutingContext context, JSONObject responseJson, String errorMessage, int statusCode) {
        responseJson.put((Object)"success", (Object)false);
        responseJson.put((Object)"error", (Object)errorMessage);
        context.response().setStatusCode(statusCode).end(responseJson.toJSONString());
    }
}

