/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.places;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.places.PlacesModule;
import nl.openminetopia.modules.places.models.WorldModel;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class PlacesVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/places/worlds").handler(this::handleGetWorlds);
        this.router.get("/api/places/cities").handler(this::handleGetCities);
        startPromise.complete();
    }

    private void handleGetWorlds(RoutingContext context) {
        JSONObject responseJson = new JSONObject();
        try {
            PlacesModule placesModule = OpenMinetopia.getModuleManager().get(PlacesModule.class);
            JSONArray worldsArray = new JSONArray();
            placesModule.getWorldModels().forEach(worldModel -> {
                JSONObject worldObject = new JSONObject();
                worldObject.put((Object)"name", (Object)worldModel.getName());
                worldObject.put((Object)"color", (Object)worldModel.getColor());
                worldObject.put((Object)"title", (Object)worldModel.getTitle());
                worldObject.put((Object)"loading_name", (Object)worldModel.getLoadingName());
                worldObject.put((Object)"temperature", (Object)worldModel.getTemperature());
                worldsArray.add((Object)worldObject);
            });
            responseJson.put((Object)"success", (Object)true);
            responseJson.put((Object)"worlds", (Object)worldsArray);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        }
        catch (Exception e) {
            this.handleError(context, responseJson, "Failed to retrieve worlds.", 500, e);
        }
    }

    private void handleGetCities(RoutingContext context) {
        JSONObject responseJson = new JSONObject();
        try {
            PlacesModule placesModule = OpenMinetopia.getModuleManager().get(PlacesModule.class);
            JSONArray citiesArray = new JSONArray();
            placesModule.getCityModels().forEach(cityModel -> {
                JSONObject cityObject = new JSONObject();
                cityObject.put((Object)"name", (Object)cityModel.getName());
                cityObject.put((Object)"color", (Object)cityModel.getColor());
                cityObject.put((Object)"title", (Object)cityModel.getTitle());
                cityObject.put((Object)"loading_name", (Object)cityModel.getLoadingName());
                cityObject.put((Object)"temperature", (Object)cityModel.getTemperature());
                Optional<WorldModel> worldModel = placesModule.getWorldModels().stream().filter(world -> world.getId().equals(cityModel.getWorldId())).findFirst();
                cityObject.put((Object)"world", (Object)worldModel.map(WorldModel::getName).orElse("Unknown"));
                citiesArray.add((Object)cityObject);
            });
            responseJson.put((Object)"success", (Object)true);
            responseJson.put((Object)"cities", (Object)citiesArray);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        }
        catch (Exception e) {
            this.handleError(context, responseJson, "Failed to retrieve cities.", 500, e);
        }
    }

    private void handleError(RoutingContext context, JSONObject responseJson, String errorMessage, int statusCode, Exception e) {
        responseJson.put((Object)"success", (Object)false);
        responseJson.put((Object)"error", (Object)errorMessage);
        context.response().setStatusCode(statusCode).end(responseJson.toJSONString());
        OpenMinetopia.getInstance().getLogger().severe("Error: " + errorMessage + " - " + e.getMessage());
    }
}

