/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.player;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONObject;

public class FitnessStatisticsVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/player/:uuid/fitness").handler(this::handleGetFitness);
        startPromise.complete();
    }

    private void handleGetFitness(RoutingContext context) {
        try {
            UUID playerUuid = UUID.fromString(context.pathParam("uuid"));
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUuid);
            JSONObject jsonObject = new JSONObject();
            if (!player.isOnline() && !player.hasPlayedBefore()) {
                jsonObject.put((Object)"success", (Object)false);
                jsonObject.put((Object)"error", (Object)"Player has not played before.");
                context.response().end(jsonObject.toJSONString());
                return;
            }
            ((CompletableFuture)PlayerManager.getInstance().getMinetopiaPlayer(player).whenComplete((minetopiaPlayer, throwable) -> {
                if (throwable != null) {
                    throwable.printStackTrace();
                    jsonObject.put((Object)"success", (Object)false);
                    jsonObject.put((Object)"error", (Object)throwable.getMessage());
                }
                if (minetopiaPlayer == null) {
                    jsonObject.put((Object)"success", (Object)false);
                    jsonObject.put((Object)"error", (Object)"MinetopiaPlayer has not loaded.");
                } else {
                    jsonObject.put((Object)"success", (Object)true);
                    JSONObject statisticsObject = new JSONObject();
                    if (player.isOnline()) {
                        minetopiaPlayer.getFitness().getFitnessModule().getFitnessRunnable().forceMarkDirty(playerUuid);
                    } else {
                        minetopiaPlayer.getFitness().getFitnessModule().getFitnessRunnable().forceMarkDirty(playerUuid);
                    }
                    minetopiaPlayer.getFitness().getStatistics().forEach(statistic -> {
                        JSONObject statisticObject = new JSONObject();
                        statisticObject.put((Object)"gained", (Object)statistic.getFitnessGained());
                        statisticObject.put((Object)"maximum", (Object)statistic.getMaximum());
                        statisticObject.put((Object)"points", (Object)statistic.getPoints());
                        statisticObject.put((Object)"secondary_points", (Object)statistic.getSecondaryPoints());
                        statisticObject.put((Object)"tertiary_points", (Object)statistic.getTertiaryPoints());
                        statisticsObject.put((Object)statistic.getType(), (Object)statisticObject);
                    });
                    jsonObject.put((Object)"statistics", (Object)statisticsObject);
                    jsonObject.put((Object)"total_fitness", (Object)minetopiaPlayer.getFitness().getTotalFitness());
                }
                context.response().end(jsonObject.toJSONString());
            })).join();
        }
        catch (Exception e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"success", (Object)false);
            jsonObject.put((Object)"error", (Object)e.getMessage());
            context.response().end(jsonObject.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("An error occurred while handling a request: " + e.getMessage());
        }
    }
}

