/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.player;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONObject;

public class PlayerBankAccountsVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/player/:uuid/bankaccounts").handler(this::handleGetBankAccounts);
        startPromise.complete();
    }

    private void handleGetBankAccounts(RoutingContext context) {
        try {
            UUID playerUuid = UUID.fromString(context.pathParam("uuid"));
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUuid);
            JSONObject jsonObject = new JSONObject();
            if (!player.isOnline() && !player.hasPlayedBefore()) {
                jsonObject.put((Object)"success", (Object)false);
                jsonObject.put((Object)"error", (Object)"Player has not played before.");
                context.response().end(jsonObject.toJSONString());
                return;
            }
            BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
            JSONObject accountsObject = new JSONObject();
            bankingModule.getAccountsFromPlayer(playerUuid).forEach(account -> {
                jsonObject.put((Object)"success", (Object)true);
                JSONObject accountObject = new JSONObject();
                accountObject.put((Object)"type", (Object)account.getType().name());
                accountObject.put((Object)"name", (Object)account.getName());
                accountObject.put((Object)"frozen", (Object)account.getFrozen());
                accountObject.put((Object)"balance", (Object)account.getBalance());
                accountsObject.put((Object)account.getUniqueId().toString(), (Object)accountObject);
            });
            ((CompletableFuture)bankingModule.getAccountByIdAsync(playerUuid).whenComplete((bankAccountModel, throwable) -> {
                if (throwable != null) {
                    throwable.printStackTrace();
                    jsonObject.put((Object)"success", (Object)false);
                    jsonObject.put((Object)"error", (Object)throwable.getMessage());
                }
                if (bankAccountModel == null) {
                    jsonObject.put((Object)"success", (Object)false);
                } else {
                    jsonObject.put((Object)"success", (Object)true);
                    JSONObject accountObject = new JSONObject();
                    accountObject.put((Object)"type", (Object)bankAccountModel.getType().name());
                    accountObject.put((Object)"name", (Object)bankAccountModel.getName());
                    accountObject.put((Object)"frozen", (Object)bankAccountModel.getFrozen());
                    accountObject.put((Object)"balance", (Object)bankAccountModel.getBalance());
                    accountsObject.put((Object)bankAccountModel.getUniqueId().toString(), (Object)accountObject);
                }
            })).join();
            jsonObject.put((Object)"accounts", (Object)accountsObject);
            context.response().end(jsonObject.toJSONString());
        }
        catch (Exception e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"success", (Object)false);
            jsonObject.put((Object)"error", (Object)e.getMessage());
            context.response().end(jsonObject.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("An error occurred while handling a request: " + e.getMessage());
        }
    }
}

