/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.player;

import com.sk89q.worldguard.protection.flags.Flag;
import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.plots.PlotModule;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import nl.openminetopia.utils.WorldGuardUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONObject;

public class PlayerPlotsVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/player/:uuid/plots").handler(this::handleGetPlots);
        startPromise.complete();
    }

    private void handleGetPlots(RoutingContext context) {
        try {
            UUID playerUuid = UUID.fromString(context.pathParam("uuid"));
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUuid);
            JSONObject jsonObject = new JSONObject();
            if (!player.isOnline() && !player.hasPlayedBefore()) {
                jsonObject.put((Object)"success", (Object)false);
                jsonObject.put((Object)"error", (Object)"Player has not played before.");
                context.response().end(jsonObject.toJSONString());
                return;
            }
            jsonObject.put((Object)"success", (Object)true);
            JSONObject plotsObject = new JSONObject();
            WorldGuardUtils.getProtectedRegions(priority -> priority >= 0).stream().filter(protectedRegion -> protectedRegion.getFlag((Flag)PlotModule.PLOT_FLAG) != null && protectedRegion.getOwners().contains(player.getUniqueId()) || protectedRegion.getMembers().contains(player.getUniqueId())).forEach(protectedRegion -> {
                JSONObject plotObject = new JSONObject();
                plotObject.put((Object)"priority", (Object)protectedRegion.getPriority());
                plotObject.put((Object)"owners", protectedRegion.getOwners().getUniqueIds().stream().map(UUID::toString).toList());
                plotObject.put((Object)"members", protectedRegion.getMembers().getUniqueIds().stream().map(UUID::toString).toList());
                JSONObject flagsObject = new JSONObject();
                protectedRegion.getFlags().forEach((flag, value) -> flagsObject.put((Object)flag.getName(), (Object)value.toString()));
                plotObject.put((Object)"flags", (Object)flagsObject);
                String description = (String)protectedRegion.getFlag((Flag)PlotModule.PLOT_DESCRIPTION);
                if (description != null && !description.isEmpty()) {
                    plotObject.put((Object)"description", protectedRegion.getFlag((Flag)PlotModule.PLOT_DESCRIPTION));
                }
                JSONObject locationObject = new JSONObject();
                JSONObject minLocationObject = new JSONObject();
                minLocationObject.put((Object)"x", (Object)protectedRegion.getMinimumPoint().x());
                minLocationObject.put((Object)"y", (Object)protectedRegion.getMinimumPoint().y());
                minLocationObject.put((Object)"z", (Object)protectedRegion.getMinimumPoint().z());
                JSONObject maxLocationObject = new JSONObject();
                maxLocationObject.put((Object)"x", (Object)protectedRegion.getMaximumPoint().x());
                maxLocationObject.put((Object)"y", (Object)protectedRegion.getMaximumPoint().y());
                maxLocationObject.put((Object)"z", (Object)protectedRegion.getMaximumPoint().z());
                locationObject.put((Object)"min", (Object)minLocationObject);
                locationObject.put((Object)"max", (Object)maxLocationObject);
                plotObject.put((Object)"location", (Object)locationObject);
                if (protectedRegion.getMembers().contains(player.getUniqueId()) && !protectedRegion.getOwners().contains(player.getUniqueId())) {
                    plotObject.put((Object)"permission", (Object)"MEMBER");
                } else {
                    plotObject.put((Object)"permission", (Object)"OWNER");
                }
                plotsObject.put((Object)protectedRegion.getId(), (Object)plotObject);
            });
            jsonObject.put((Object)"plots", (Object)plotsObject);
            context.response().end(jsonObject.toJSONString());
        }
        catch (Exception e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"success", (Object)false);
            jsonObject.put((Object)"error", (Object)e.getMessage());
            context.response().end(jsonObject.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("An error occurred while handling a request: " + e.getMessage());
        }
    }
}

