/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.player;

import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.color.enums.OwnableColorType;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.json.simple.JSONObject;

public class PlayerVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/player/:uuid").handler(this::handleGetPlayer);
        startPromise.complete();
    }

    private void handleGetPlayer(RoutingContext context) {
        try {
            UUID playerUuid = UUID.fromString(context.pathParam("uuid"));
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerUuid);
            JSONObject jsonObject = new JSONObject();
            if (!player.isOnline() && !player.hasPlayedBefore()) {
                jsonObject.put((Object)"success", (Object)false);
                jsonObject.put((Object)"error", (Object)"Player has not played before.");
                context.response().end(jsonObject.toJSONString());
                return;
            }
            ((CompletableFuture)PlayerManager.getInstance().getMinetopiaPlayer(player).whenComplete((minetopiaPlayer, throwable) -> {
                if (throwable != null) {
                    throwable.printStackTrace();
                    jsonObject.put((Object)"success", (Object)false);
                    jsonObject.put((Object)"error", (Object)throwable.getMessage());
                }
                if (minetopiaPlayer == null) {
                    jsonObject.put((Object)"success", (Object)false);
                    jsonObject.put((Object)"error", (Object)"MinetopiaPlayer has not loaded.");
                } else {
                    jsonObject.put((Object)"success", (Object)true);
                    jsonObject.put((Object)"uuid", (Object)player.getUniqueId().toString());
                    jsonObject.put((Object)"level", (Object)minetopiaPlayer.getLevel());
                    jsonObject.put((Object)"calculated_level", (Object)minetopiaPlayer.getCalculatedLevel());
                    jsonObject.put((Object)"fitness", (Object)minetopiaPlayer.getFitness().getTotalFitness());
                    jsonObject.put((Object)"active_prefix", (Object)minetopiaPlayer.getActivePrefix().getPrefix());
                    jsonObject.put((Object)"active_prefix_color", (Object)minetopiaPlayer.getActiveColor(OwnableColorType.PREFIX).displayName());
                    jsonObject.put((Object)"active_name_color", (Object)minetopiaPlayer.getActiveColor(OwnableColorType.NAME).displayName());
                    jsonObject.put((Object)"active_level_color", (Object)minetopiaPlayer.getActiveColor(OwnableColorType.LEVEL).displayName());
                    jsonObject.put((Object)"active_chat_color", (Object)minetopiaPlayer.getActiveColor(OwnableColorType.CHAT).displayName());
                    jsonObject.put((Object)"playtimeSeconds", (Object)(minetopiaPlayer.getPlaytime() / 1000L));
                    jsonObject.put((Object)"online", (Object)player.isOnline());
                }
                context.response().end(jsonObject.toJSONString());
            })).join();
        }
        catch (Exception e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"success", (Object)false);
            jsonObject.put((Object)"error", (Object)e.getMessage());
            context.response().end(jsonObject.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("An error occurred while handling a request: " + e.getMessage());
        }
    }
}

