/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.restapi.verticles.plots;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import io.vertx.core.Promise;
import io.vertx.ext.web.RoutingContext;
import java.util.UUID;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.plots.PlotModule;
import nl.openminetopia.modules.restapi.base.BaseVerticle;
import nl.openminetopia.utils.WorldGuardUtils;
import org.json.simple.JSONObject;

public class PlotsVerticle
extends BaseVerticle {
    @Override
    public void start(Promise<Void> startPromise) {
        this.router.get("/api/plots").handler(this::handleGetPlots);
        this.router.get("/api/plots/:id").handler(this::handleGetPlot);
        this.router.post("/api/plots/:id/owners/add").handler(this::handleAddOwner);
        this.router.post("/api/plots/:id/owners/remove").handler(this::handleRemoveOwner);
        this.router.post("/api/plots/:id/members/add").handler(this::handleAddMember);
        this.router.post("/api/plots/:id/members/remove").handler(this::handleRemoveMember);
        startPromise.complete();
    }

    private void handleGetPlot(RoutingContext context) {
        String regionId = context.pathParam("id");
        JSONObject responseJson = new JSONObject();
        try {
            ProtectedRegion region = WorldGuardUtils.getProtectedRegions(priority -> priority >= 0).stream().filter(protectedRegion -> protectedRegion.getId().equals(regionId)).findFirst().orElse(null);
            if (region == null) {
                responseJson.put((Object)"success", (Object)false);
                responseJson.put((Object)"error", (Object)"Region not found.");
                context.response().setStatusCode(404).end(responseJson.toJSONString());
                return;
            }
            JSONObject plotObject = new JSONObject();
            plotObject.put((Object)"priority", (Object)region.getPriority());
            plotObject.put((Object)"owners", region.getOwners().getUniqueIds().stream().map(UUID::toString).toList());
            plotObject.put((Object)"members", region.getMembers().getUniqueIds().stream().map(UUID::toString).toList());
            JSONObject flagsObject = new JSONObject();
            region.getFlags().forEach((flag, value) -> flagsObject.put((Object)flag.getName(), (Object)value.toString()));
            plotObject.put((Object)"flags", (Object)flagsObject);
            String description = (String)region.getFlag((Flag)PlotModule.PLOT_DESCRIPTION);
            if (description != null && !description.isEmpty()) {
                plotObject.put((Object)"description", (Object)description);
            }
            JSONObject locationObject = new JSONObject();
            JSONObject minLocationObject = new JSONObject();
            minLocationObject.put((Object)"x", (Object)region.getMinimumPoint().x());
            minLocationObject.put((Object)"y", (Object)region.getMinimumPoint().y());
            minLocationObject.put((Object)"z", (Object)region.getMinimumPoint().z());
            JSONObject maxLocationObject = new JSONObject();
            maxLocationObject.put((Object)"x", (Object)region.getMaximumPoint().x());
            maxLocationObject.put((Object)"y", (Object)region.getMaximumPoint().y());
            maxLocationObject.put((Object)"z", (Object)region.getMaximumPoint().z());
            locationObject.put((Object)"min", (Object)minLocationObject);
            locationObject.put((Object)"max", (Object)maxLocationObject);
            plotObject.put((Object)"location", (Object)locationObject);
            responseJson.put((Object)"success", (Object)true);
            responseJson.put((Object)"plot", (Object)plotObject);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        }
        catch (Exception e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)("An error occurred while retrieving the plot: " + e.getMessage()));
            context.response().setStatusCode(500).end(responseJson.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("Error retrieving plot: " + e.getMessage());
        }
    }

    private void handleGetPlots(RoutingContext context) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"success", (Object)true);
            JSONObject plotsObject = new JSONObject();
            WorldGuardUtils.getProtectedRegions(priority -> priority >= 0).stream().filter(protectedRegion -> protectedRegion.getFlag((Flag)PlotModule.PLOT_FLAG) != null).forEach(protectedRegion -> {
                JSONObject plotObject = new JSONObject();
                plotObject.put((Object)"priority", (Object)protectedRegion.getPriority());
                plotObject.put((Object)"owners", protectedRegion.getOwners().getUniqueIds().stream().map(UUID::toString).toList());
                plotObject.put((Object)"members", protectedRegion.getMembers().getUniqueIds().stream().map(UUID::toString).toList());
                JSONObject flagsObject = new JSONObject();
                protectedRegion.getFlags().forEach((flag, value) -> flagsObject.put((Object)flag.getName(), (Object)value.toString()));
                plotObject.put((Object)"flags", (Object)flagsObject);
                String description = (String)protectedRegion.getFlag((Flag)PlotModule.PLOT_DESCRIPTION);
                if (description != null && !description.isEmpty()) {
                    plotObject.put((Object)"description", protectedRegion.getFlag((Flag)PlotModule.PLOT_DESCRIPTION));
                }
                JSONObject locationObject = new JSONObject();
                JSONObject minLocationObject = new JSONObject();
                minLocationObject.put((Object)"x", (Object)protectedRegion.getMinimumPoint().x());
                minLocationObject.put((Object)"y", (Object)protectedRegion.getMinimumPoint().y());
                minLocationObject.put((Object)"z", (Object)protectedRegion.getMinimumPoint().z());
                JSONObject maxLocationObject = new JSONObject();
                maxLocationObject.put((Object)"x", (Object)protectedRegion.getMaximumPoint().x());
                maxLocationObject.put((Object)"y", (Object)protectedRegion.getMaximumPoint().y());
                maxLocationObject.put((Object)"z", (Object)protectedRegion.getMaximumPoint().z());
                locationObject.put((Object)"min", (Object)minLocationObject);
                locationObject.put((Object)"max", (Object)maxLocationObject);
                plotObject.put((Object)"location", (Object)locationObject);
                plotsObject.put((Object)protectedRegion.getId(), (Object)plotObject);
            });
            jsonObject.put((Object)"plots", (Object)plotsObject);
            context.response().end(jsonObject.toJSONString());
        }
        catch (Exception e) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"success", (Object)false);
            jsonObject.put((Object)"error", (Object)e.getMessage());
            context.response().end(jsonObject.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("An error occurred while handling a request: " + e.getMessage());
        }
    }

    private void handleAddOwner(RoutingContext context) {
        this.modifyRegionMembership(context, true, true);
    }

    private void handleRemoveOwner(RoutingContext context) {
        this.modifyRegionMembership(context, true, false);
    }

    private void handleAddMember(RoutingContext context) {
        this.modifyRegionMembership(context, false, true);
    }

    private void handleRemoveMember(RoutingContext context) {
        this.modifyRegionMembership(context, false, false);
    }

    private void modifyRegionMembership(RoutingContext context, boolean isOwner, boolean add) {
        UUID playerUuid;
        JSONObject responseJson = new JSONObject();
        String regionId = context.pathParam("id");
        String uuidString = context.body().asJsonObject().getString("uuid");
        try {
            playerUuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)"Invalid UUID format.");
            context.response().setStatusCode(400).end(responseJson.toJSONString());
            return;
        }
        ProtectedRegion region = WorldGuardUtils.getProtectedRegions(priority -> priority >= 0).stream().filter(protectedRegion -> protectedRegion.getId().equals(regionId)).findFirst().orElse(null);
        if (region == null) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)"Region not found.");
            context.response().setStatusCode(404).end(responseJson.toJSONString());
            return;
        }
        try {
            if (isOwner) {
                if (add) {
                    region.getOwners().addPlayer(playerUuid);
                } else {
                    region.getOwners().removePlayer(playerUuid);
                }
            } else if (add) {
                region.getMembers().addPlayer(playerUuid);
            } else {
                region.getMembers().removePlayer(playerUuid);
            }
            responseJson.put((Object)"success", (Object)true);
            context.response().setStatusCode(200).end(responseJson.toJSONString());
        }
        catch (Exception e) {
            responseJson.put((Object)"success", (Object)false);
            responseJson.put((Object)"error", (Object)("An error occurred while modifying the region: " + e.getMessage()));
            context.response().setStatusCode(500).end(responseJson.toJSONString());
            OpenMinetopia.getInstance().getLogger().severe("Error modifying region: " + e.getMessage());
        }
    }
}

