/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.scoreboard;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.ScoreboardManager;
import nl.openminetopia.configuration.DefaultConfiguration;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.scoreboard.commands.ScoreboardCommand;
import nl.openminetopia.modules.scoreboard.listeners.PlayerJoinListener;
import nl.openminetopia.modules.scoreboard.listeners.PlayerQuitListener;
import nl.openminetopia.modules.scoreboard.runnables.ScoreboardUpdateRunnable;
import nl.openminetopia.shaded.scoreboard.api.ScoreboardLibrary;
import nl.openminetopia.shaded.scoreboard.api.exception.NoPacketAdapterAvailableException;
import nl.openminetopia.shaded.scoreboard.api.noop.NoopScoreboardLibrary;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ScoreboardModule
extends ExtendedSpigotModule {
    private ScoreboardLibrary scoreboardLibrary;
    private ScoreboardUpdateRunnable scoreboardUpdateRunnable;

    public ScoreboardModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        if (!configuration.isScoreboardEnabled()) {
            return;
        }
        this.registerComponent(new PlayerJoinListener());
        this.registerComponent(new PlayerQuitListener());
        this.registerComponent(new ScoreboardCommand(this));
        try {
            this.scoreboardLibrary = ScoreboardLibrary.loadScoreboardLibrary((Plugin)OpenMinetopia.getInstance());
        }
        catch (NoPacketAdapterAvailableException e) {
            this.scoreboardLibrary = new NoopScoreboardLibrary();
            OpenMinetopia.getInstance().getLogger().info("No scoreboard packet adapter available!");
        }
        this.scoreboardUpdateRunnable = new ScoreboardUpdateRunnable(ScoreboardManager.getInstance(), PlayerManager.getInstance(), 5000L, 50, 30000L, () -> new ArrayList<UUID>(ScoreboardManager.getInstance().getScoreboards().keySet()));
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.scoreboardUpdateRunnable, 20L);
    }

    @Override
    public void onDisable() {
        if (this.scoreboardLibrary != null) {
            this.scoreboardLibrary.close();
        }
        if (this.scoreboardUpdateRunnable != null) {
            OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.scoreboardUpdateRunnable);
        }
    }

    @Generated
    public ScoreboardLibrary getScoreboardLibrary() {
        return this.scoreboardLibrary;
    }

    @Generated
    public ScoreboardUpdateRunnable getScoreboardUpdateRunnable() {
        return this.scoreboardUpdateRunnable;
    }
}

