/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.scoreboard.runnables;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.ScoreboardManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.framework.runnables.AbstractDirtyRunnable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ScoreboardUpdateRunnable
extends AbstractDirtyRunnable<UUID> {
    private final ScoreboardManager scoreboardManager;
    private final PlayerManager playerManager;

    public ScoreboardUpdateRunnable(ScoreboardManager scoreboardManager, PlayerManager playerManager, long minIntervalMs, int batch, long heartbeatMs, Supplier<List<UUID>> allKeysSupplier) {
        super(minIntervalMs, batch, heartbeatMs, allKeysSupplier);
        this.scoreboardManager = scoreboardManager;
        this.playerManager = playerManager;
    }

    @Override
    protected void process(UUID key) {
        Player player = Bukkit.getPlayer((UUID)key);
        if (player == null || !player.isOnline()) {
            this.scoreboardManager.removeScoreboard(key);
            this.remove(key);
            return;
        }
        MinetopiaPlayer mtp = this.playerManager.getOnlineMinetopiaPlayer(player);
        if (mtp == null) {
            return;
        }
        this.scoreboardManager.updateBoard(mtp);
    }
}

