/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.police.models.CriminalRecordModel;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EffRemoveCriminalRecord
extends Effect {
    private Expression<Player> player;
    private Expression<Integer> id;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.player = expressions[1];
        this.id = expressions[0];
        return true;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "Remove CriminalRecord effect with ID integer expression" + this.id.toString(event, debug) + " and player expression" + this.player.toString(event, debug);
    }

    protected void execute(Event event) {
        for (Player user : (Player[])this.player.getAll(event)) {
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(user);
            if (minetopiaPlayer == null) continue;
            for (CriminalRecordModel criminalRecord : minetopiaPlayer.getCriminalRecords()) {
                if (criminalRecord.getId() != this.id.getSingle(event)) continue;
                minetopiaPlayer.removeCriminalRecord(criminalRecord);
            }
        }
    }

    static {
        Skript.registerEffect(EffRemoveCriminalRecord.class, (String[])new String[]{"(omt|openminetopia) remove criminalrecord %integer% from %players%"});
    }
}

