/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.staff.admintool.commands.subcommands;

import java.util.concurrent.CompletableFuture;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.staff.admintool.menus.AdminToolMenu;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="admintool")
public class AdminToolOpenCommand
extends BaseCommand {
    @Subcommand(value="open")
    @CommandCompletion(value="@players")
    @CommandPermission(value="openminetopia.admintool.open")
    public void open(Player player, OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null || !offlinePlayer.hasPlayedBefore()) {
            player.sendMessage(ChatUtils.color("<red>Deze speler heeft nog nooit gespeeld."));
            return;
        }
        CompletableFuture<MinetopiaPlayer> future = PlayerManager.getInstance().getMinetopiaPlayer(offlinePlayer);
        future.whenComplete((minetopiaPlayer, throwable) -> {
            if (throwable != null) {
                player.sendMessage(ChatUtils.color("<red>Er is een fout opgetreden bij het openen van de AdminTool."));
                throwable.printStackTrace();
                return;
            }
            if (minetopiaPlayer == null) {
                return;
            }
            if (!offlinePlayer.isOnline()) {
                minetopiaPlayer.getFitness().getFitnessModule().getFitnessRunnable().forceMarkDirty(offlinePlayer.getUniqueId());
            }
            BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
            BankAccountModel bankAccountModel = bankingModule.getAccountByIdAsync(offlinePlayer.getUniqueId()).join();
            Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> new AdminToolMenu(player, offlinePlayer, (MinetopiaPlayer)minetopiaPlayer, bankAccountModel).open(player));
        });
    }
}

