/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.staff.mod.commands.subcommands;

import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.player.events.PlayerLevelChangeEvent;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.events.EventUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="mod")
public class ModSetLevelCommand
extends BaseCommand {
    @Subcommand(value="setlevel")
    @Syntax(value="<player> <level>")
    @CommandPermission(value="openminetopia.mod.setlevel")
    @CommandCompletion(value="@players @range:1-100")
    @Description(value="Set the level of a player.")
    public void level(Player player, OfflinePlayer offlinePlayer, int newLevel) {
        if (offlinePlayer.getPlayer() == null) {
            player.sendMessage("This player does not exist.");
            return;
        }
        PlayerManager.getInstance().getMinetopiaPlayer((OfflinePlayer)offlinePlayer.getPlayer()).whenComplete((minetopiaPlayer, throwable1) -> {
            if (minetopiaPlayer == null) {
                return;
            }
            int oldLevel = minetopiaPlayer.getLevel();
            PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(offlinePlayer.getPlayer(), oldLevel, newLevel);
            if (EventUtils.callCancellable(event)) {
                return;
            }
            minetopiaPlayer.setLevel(newLevel);
            player.sendMessage("Set the level of the player to " + newLevel + ".");
        });
    }
}

