/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.teleporter.commands.subcommands;

import nl.openminetopia.modules.teleporter.utils.TeleporterUtil;
import nl.openminetopia.modules.teleporter.utils.enums.PressurePlate;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@CommandAlias(value="teleporter")
public final class TeleporterCreateCommand
extends BaseCommand {
    @Subcommand(value="create")
    @CommandPermission(value="openminetopia.teleporter.create")
    @Syntax(value="[plate] [addDisplay] [roundYaw]")
    public void create(Player player, @Optional PressurePlate plate, @Optional Boolean addDisplay, @Optional Boolean roundYaw) {
        if (plate == null) {
            plate = PressurePlate.STONE_PRESSURE_PLATE;
        }
        if (addDisplay == null) {
            addDisplay = true;
        }
        if (roundYaw == null) {
            roundYaw = false;
        }
        Location location = player.getLocation();
        if (roundYaw.booleanValue()) {
            location.setYaw((float)(Math.round(location.getYaw() / 45.0f) * 45));
        }
        ItemStack item = TeleporterUtil.buildPlate(plate, location, addDisplay);
        player.getInventory().addItem(new ItemStack[]{item});
        player.sendMessage(ChatUtils.color("<gold>Teleporter successfully created."));
    }
}

