/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.teleporter.utils;

import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.DefaultConfiguration;
import nl.openminetopia.modules.teleporter.utils.enums.PressurePlate;
import nl.openminetopia.shaded.customblockdata.CustomBlockData;
import nl.openminetopia.shaded.morepersistentdatatypes.DataType;
import nl.openminetopia.utils.PersistentDataUtil;
import nl.openminetopia.utils.item.ItemBuilder;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;

public final class TeleporterUtil {
    public static ItemStack buildPlate(PressurePlate plate, Location location, boolean addDisplay) {
        ItemBuilder builder = new ItemBuilder(plate.getMaterial());
        builder.setName("<gold>Teleporter Plate");
        builder.addLoreLine("<dark_gray>X: <gray>" + location.x());
        builder.addLoreLine("<dark_gray>Y: <gray>" + location.y());
        builder.addLoreLine("<dark_gray>Z: <gray>" + location.z());
        builder.addLoreLine("<dark_gray>World: <gray>" + location.getWorld().getName());
        builder.setNBT("teleporter.x", location.x());
        builder.setNBT("teleporter.y", location.y());
        builder.setNBT("teleporter.z", location.z());
        builder.setNBT("teleporter.yaw", Float.valueOf(location.getYaw()));
        builder.setNBT("teleporter.pitch", Float.valueOf(location.getPitch()));
        builder.setNBT("teleporter.world", location.getWorld().getName());
        if (addDisplay) {
            builder.setNBT("teleporter.display", true);
        }
        return builder.toItemStack();
    }

    public static Location decodeNBT(ItemStack item) {
        Double x = PersistentDataUtil.getDouble(item, "teleporter.x");
        Double y = PersistentDataUtil.getDouble(item, "teleporter.y");
        Double z = PersistentDataUtil.getDouble(item, "teleporter.z");
        Float yaw = (Float)PersistentDataUtil.get(item, "teleporter.yaw");
        Float pitch = (Float)PersistentDataUtil.get(item, "teleporter.pitch");
        String worldName = PersistentDataUtil.getString(item, "teleporter.world");
        if (x == null || y == null || z == null || yaw == null || pitch == null || worldName == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)worldName), x.doubleValue(), y.doubleValue(), z.doubleValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static Location blockLocation(Block block) {
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        return (Location)data.get(new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "teleporter.location"), DataType.LOCATION);
    }

    public static void setTeleporter(Block block, Location location, boolean addDisplay) {
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        data.set(new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "teleporter.location"), DataType.LOCATION, location);
        if (!addDisplay) {
            return;
        }
        Entity display = TeleporterUtil.addDisplay(block, location);
        data.set(new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "teleporter.entity"), DataType.UUID, display.getUniqueId());
    }

    public static Entity addDisplay(Block block, Location location) {
        Location blockLocation = block.getLocation();
        blockLocation.add(0.5, 1.4, 0.5);
        TextDisplay display = (TextDisplay)block.getWorld().spawn(blockLocation, TextDisplay.class);
        display.text(TeleporterUtil.displayText(location));
        display.setBillboard(Display.Billboard.CENTER);
        display.setAlignment(TextDisplay.TextAlignment.CENTER);
        display.setShadowed(true);
        display.setBackgroundColor(Color.fromARGB((int)0, (int)0, (int)0, (int)0));
        Transformation transformation = display.getTransformation();
        transformation.getScale().set(0.5);
        display.setTransformation(transformation);
        return display;
    }

    private static Component displayText(Location location) {
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        String text = StringUtils.join(configuration.getTeleporterDisplayLines(), (String)"\n<reset>");
        text = text.replace("<x>", String.valueOf((int)location.x())).replace("<y>", String.valueOf((int)location.y())).replace("<z>", String.valueOf((int)location.z())).replace("<world>", location.getWorld().getName());
        return MiniMessage.miniMessage().deserialize((Object)text);
    }

    public static void removeTeleporter(Block block) {
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        UUID uuid = (UUID)data.get(new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "teleporter.entity"), DataType.UUID);
        if (uuid == null) {
            return;
        }
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity == null) {
            return;
        }
        entity.remove();
    }

    public static boolean isTeleporterItem(ItemStack item) {
        if (item == null || item.getType().equals((Object)Material.AIR)) {
            return false;
        }
        return PersistentDataUtil.getDouble(item, "teleporter.x") != null;
    }

    public static boolean isTeleporterBlock(Block block) {
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        return data.has(new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "teleporter.location"));
    }

    @Generated
    private TeleporterUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

