/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.transactions;

import com.craftmend.storm.api.enums.Where;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.transactions.commands.TransactionCommand;
import nl.openminetopia.modules.transactions.enums.TransactionType;
import nl.openminetopia.modules.transactions.objects.TransactionModel;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class TransactionsModule
extends ExtendedSpigotModule {
    public TransactionsModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.registerComponent(new TransactionCommand());
    }

    public CompletableFuture<TransactionModel> createTransactionLog(long time, UUID player, String username, TransactionType type, double amount, UUID bankAccount, String description) {
        CompletableFuture<TransactionModel> completableFuture = new CompletableFuture<TransactionModel>();
        StormDatabase.getExecutorService().submit(() -> {
            TransactionModel transactionModel = new TransactionModel();
            transactionModel.setTime(time);
            transactionModel.setPlayer(player);
            transactionModel.setUsername(username);
            transactionModel.setType(type);
            transactionModel.setAmount(amount);
            transactionModel.setBankAccount(bankAccount);
            transactionModel.setDescription(description);
            StormDatabase.getInstance().saveStormModel(transactionModel);
            completableFuture.complete(transactionModel);
        });
        return completableFuture;
    }

    public CompletableFuture<Collection<TransactionModel>> getAccountTransactions(LookupType type, UUID uuid) {
        CompletableFuture<Collection<TransactionModel>> completableFuture = new CompletableFuture<Collection<TransactionModel>>();
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<TransactionModel> transactionModels = StormDatabase.getInstance().getStorm().buildQuery(TransactionModel.class).where(type.getRowName(), Where.EQUAL, uuid.toString()).limit(250).execute().join();
                completableFuture.complete(transactionModels);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public static enum LookupType {
        PLAYER("player_uuid"),
        BANK_ACCOUNT("bank_account");

        private final String rowName;

        @Generated
        public String getRowName() {
            return this.rowName;
        }

        @Generated
        private LookupType(String rowName) {
            this.rowName = rowName;
        }
    }
}

