/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.transactions.commands;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.menus.BankTransactionsMenu;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Default;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.entity.Player;

@CommandAlias(value="transactions|transacties")
@CommandPermission(value="openminetopia.transactions")
public class TransactionCommand
extends BaseCommand {
    private final TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);
    private final BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);

    @Default
    @Syntax(value="<name>")
    @CommandCompletion(value="@accountNames")
    public void checkTransactionHistory(Player player, String accountName) {
        BankAccountModel accountModel = this.bankingModule.getAccountByName(accountName);
        if (accountModel == null) {
            ChatUtils.sendMessage(player, MessageConfiguration.message("banking_account_not_found"));
            return;
        }
        new BankTransactionsMenu(player, accountModel).open(player);
    }
}

