/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.gui.builder.gui;

import java.util.function.Consumer;
import nl.openminetopia.shaded.gui.builder.gui.BaseGuiBuilder;
import nl.openminetopia.shaded.gui.builder.gui.ChestGuiBuilder;
import nl.openminetopia.shaded.gui.components.GuiContainer;
import nl.openminetopia.shaded.gui.components.GuiType;
import nl.openminetopia.shaded.gui.components.InventoryProvider;
import nl.openminetopia.shaded.gui.components.util.Legacy;
import nl.openminetopia.shaded.gui.guis.Gui;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TypedGuiBuilder
extends BaseGuiBuilder<Gui, TypedGuiBuilder> {
    private GuiType guiType;
    private InventoryProvider.Typed inventoryProvider = (title, owner, type) -> Bukkit.createInventory((InventoryHolder)owner, (InventoryType)type, (String)Legacy.SERIALIZER.serialize(title));

    public TypedGuiBuilder(@NotNull GuiType guiType) {
        this.guiType = guiType;
    }

    public TypedGuiBuilder(@NotNull GuiType guiType, @NotNull ChestGuiBuilder builder) {
        this.guiType = guiType;
        this.consumeBuilder(builder);
    }

    @NotNull
    @Contract(value="_ -> this")
    public TypedGuiBuilder type(@NotNull GuiType guiType) {
        this.guiType = guiType;
        return this;
    }

    @NotNull
    @Contract(value="_ -> this")
    public TypedGuiBuilder inventory(@NotNull InventoryProvider.Typed inventoryProvider) {
        this.inventoryProvider = inventoryProvider;
        return this;
    }

    @Override
    @NotNull
    @Contract(value=" -> new")
    public Gui create() {
        Gui gui = new Gui(new GuiContainer.Typed(this.getTitle(), this.inventoryProvider, this.guiType), this.getModifiers());
        Consumer consumer = this.getConsumer();
        if (consumer != null) {
            consumer.accept(gui);
        }
        return gui;
    }
}

