/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.api.noop;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.openminetopia.shaded.scoreboard.api.noop.NoopScoreboardObjective;
import nl.openminetopia.shaded.scoreboard.api.objective.ObjectiveDisplaySlot;
import nl.openminetopia.shaded.scoreboard.api.objective.ObjectiveManager;
import nl.openminetopia.shaded.scoreboard.api.objective.ScoreboardObjective;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

class NoopObjectiveManager
implements ObjectiveManager {
    private final Map<String, ScoreboardObjective> objectives = new HashMap<String, ScoreboardObjective>();
    private final Set<Player> players = new HashSet<Player>();
    private boolean isClosed = true;

    NoopObjectiveManager() {
    }

    @Override
    @NotNull
    public ScoreboardObjective create(@NotNull String name) {
        return this.objectives.computeIfAbsent(name, i -> new NoopScoreboardObjective());
    }

    @Override
    public void remove(@NotNull ScoreboardObjective objective) {
        this.objectives.values().remove(objective);
    }

    @Override
    public void display(@NotNull ObjectiveDisplaySlot displaySlot, @NotNull ScoreboardObjective objective) {
    }

    @Override
    @NotNull
    public Collection<Player> players() {
        return Collections.unmodifiableSet(this.players);
    }

    @Override
    public boolean addPlayer(@NotNull Player player) {
        return this.players.add(player);
    }

    @Override
    public boolean removePlayer(@NotNull Player player) {
        return this.players.remove(player);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public boolean closed() {
        return this.isClosed;
    }
}

