/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.api.noop;

import java.util.Locale;
import nl.openminetopia.shaded.scoreboard.api.ScoreboardLibrary;
import nl.openminetopia.shaded.scoreboard.api.noop.NoopObjectiveManager;
import nl.openminetopia.shaded.scoreboard.api.noop.NoopSidebar;
import nl.openminetopia.shaded.scoreboard.api.noop.NoopTeamManager;
import nl.openminetopia.shaded.scoreboard.api.objective.ObjectiveManager;
import nl.openminetopia.shaded.scoreboard.api.sidebar.Sidebar;
import nl.openminetopia.shaded.scoreboard.api.team.TeamManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class NoopScoreboardLibrary
implements ScoreboardLibrary {
    private boolean closed = false;

    @Override
    @NotNull
    public Sidebar createSidebar(@Range(from=1L, to=0x7FFFFFFFL) int maxLines, @Nullable Locale locale, @NotNull String objectiveName) {
        this.checkClosed();
        return new NoopSidebar(maxLines, objectiveName, locale);
    }

    @Override
    @NotNull
    public TeamManager createTeamManager() {
        this.checkClosed();
        return new NoopTeamManager();
    }

    @Override
    @NotNull
    public ObjectiveManager createObjectiveManager() {
        this.checkClosed();
        return new NoopObjectiveManager();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("NoopScoreboardLibrary is closed");
        }
    }
}

