/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.api.objective;

import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import nl.openminetopia.shaded.scoreboard.api.objective.ScoreFormat;
import org.jetbrains.annotations.Nullable;

public final class ObjectiveScore {
    private final int value;
    private final Component displayName;
    private final ScoreFormat format;

    public ObjectiveScore(int value, @Nullable ComponentLike displayName, @Nullable ScoreFormat format) {
        this.value = value;
        this.displayName = displayName == null ? null : displayName.asComponent();
        this.format = format;
    }

    public int value() {
        return this.value;
    }

    @Nullable
    public Component displayName() {
        return this.displayName;
    }

    @Nullable
    public ScoreFormat format() {
        return this.format;
    }

    public String toString() {
        return "ObjectiveScore{value=" + this.value + ", displayName=" + this.displayName + ", format=" + this.format + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectiveScore that = (ObjectiveScore)o;
        if (this.value != that.value) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        return Objects.equals(this.format, that.format);
    }

    public int hashCode() {
        int result = this.value;
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        return result;
    }
}

