/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern;

import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.Packet;
import nl.openminetopia.shaded.scoreboard.implementation.commons.LineRenderingStrategy;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.PacketAdapterProvider;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.PacketSender;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.ComponentProvider;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.ComponentProviderImpl;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.objective.PaperObjectivePacketAdapter;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.objective.SpigotObjectivePacketAdapter;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.team.PaperTeamsPacketAdapterImpl;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.team.SpigotTeamsPacketAdapter;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.util.PacketUtil;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.objective.ObjectivePacketAdapter;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.TeamsPacketAdapter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PacketAdapterProviderImpl
implements PacketAdapterProvider,
PacketSender<Packet<?>> {
    private boolean isNativeAdventure;
    private final ComponentProvider componentProvider;

    public PacketAdapterProviderImpl() {
        try {
            Class.forName("io.papermc.paper.adventure.PaperAdventure");
            String notRelocatedPackage = "net.ky".concat("ori.adventure.text");
            if (Component.class.getPackage().getName().equals(notRelocatedPackage)) {
                this.isNativeAdventure = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.componentProvider = new ComponentProviderImpl(this.isNativeAdventure);
    }

    @Override
    @NotNull
    public ObjectivePacketAdapter createObjectiveAdapter(@NotNull String objectiveName) {
        return this.isNativeAdventure ? new PaperObjectivePacketAdapter(this, this.componentProvider, objectiveName) : new SpigotObjectivePacketAdapter(this, this.componentProvider, objectiveName);
    }

    @Override
    @NotNull
    public TeamsPacketAdapter createTeamPacketAdapter(@NotNull String teamName) {
        return this.isNativeAdventure ? new PaperTeamsPacketAdapterImpl(this, this.componentProvider, teamName) : new SpigotTeamsPacketAdapter(this, this.componentProvider, teamName);
    }

    @Override
    @NotNull
    public LineRenderingStrategy lineRenderingStrategy(@NotNull Player player) {
        return LineRenderingStrategy.MODERN;
    }

    @Override
    public void sendPacket(@NotNull Player player, @NotNull Packet<?> packet) {
        PacketUtil.sendPacket(player, packet);
    }
}

