/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.team;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.ChatFormatting;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.world.scores.Team;
import nl.openminetopia.shaded.scoreboard.implementation.commons.LegacyFormatUtil;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.ImmutableTeamProperties;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.PacketSender;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.ComponentProvider;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.modern.PacketAccessors;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.EntriesPacketType;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.TeamConstants;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.TeamsPacketAdapter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class AbstractTeamsPacketAdapterImpl
implements TeamsPacketAdapter {
    protected final PacketSender<Packet<?>> sender;
    protected final ComponentProvider componentProvider;
    protected final String teamName;
    private ClientboundSetPlayerTeamPacket removePacket;

    public AbstractTeamsPacketAdapterImpl(@NotNull PacketSender<Packet<?>> sender, @NotNull ComponentProvider componentProvider, @NotNull String teamName) {
        this.sender = sender;
        this.componentProvider = componentProvider;
        this.teamName = teamName;
    }

    public static ClientboundSetPlayerTeamPacket createTeamsPacket(int method, @NotNull String name, @Nullable ClientboundSetPlayerTeamPacket.Parameters parameters, @Nullable Collection<String> entries) {
        return PacketAccessors.TEAM_PACKET_CONSTRUCTOR.invoke(name, method, Optional.ofNullable(parameters), entries == null ? Collections.emptyList() : entries);
    }

    @Override
    public void removeTeam(@NotNull Iterable<Player> players) {
        if (this.removePacket == null) {
            this.removePacket = AbstractTeamsPacketAdapterImpl.createTeamsPacket(1, this.teamName, null, null);
        }
        this.sender.sendPacket(players, (Packet<?>)this.removePacket);
    }

    public abstract class TeamDisplayPacketAdapterImpl
    implements TeamDisplayPacketAdapter {
        protected final ImmutableTeamProperties<Component> properties;

        public TeamDisplayPacketAdapterImpl(ImmutableTeamProperties<Component> properties) {
            this.properties = properties;
        }

        @Override
        public void sendEntries(@NotNull EntriesPacketType packetType, @NotNull Collection<Player> players, @NotNull Collection<String> entries) {
            AbstractTeamsPacketAdapterImpl.this.sender.sendPacket((Iterable<Player>)players, (Packet<?>)AbstractTeamsPacketAdapterImpl.createTeamsPacket(TeamConstants.mode(packetType), AbstractTeamsPacketAdapterImpl.this.teamName, null, entries));
        }

        protected void fillParameters(@NotNull ClientboundSetPlayerTeamPacket.Parameters parameters, @UnknownNullability Locale locale) {
            if (PacketAccessors.IS_1_21_5_OR_ABOVE) {
                Objects.requireNonNull(PacketAccessors.NAME_TAG_VISIBILITY_FIELD_1_21_5).set(parameters, Team.Visibility.valueOf((String)this.properties.nameTagVisibility().name()));
                Objects.requireNonNull(PacketAccessors.COLLISION_RULE_FIELD_1_21_5).set(parameters, Team.CollisionRule.valueOf((String)this.properties.collisionRule().name()));
            } else {
                Objects.requireNonNull(PacketAccessors.NAME_TAG_VISIBILITY_FIELD_1_21_4).set(parameters, this.properties.nameTagVisibility().key());
                Objects.requireNonNull(PacketAccessors.COLLISION_RULE_FIELD_1_21_4).set(parameters, this.properties.collisionRule().key());
            }
            char legacyChar = LegacyFormatUtil.getChar(this.properties.playerColor());
            PacketAccessors.COLOR_FIELD.set(parameters, ChatFormatting.getByCode((char)legacyChar));
            int options = this.properties.packOptions();
            PacketAccessors.OPTIONS_FIELD.set(parameters, options);
        }
    }
}

