/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.player;

import nl.openminetopia.shaded.scoreboard.implementation.ScoreboardLibraryImpl;
import nl.openminetopia.shaded.scoreboard.implementation.objective.ObjectiveManagerImpl;
import nl.openminetopia.shaded.scoreboard.implementation.objective.ObjectiveManagerTask;
import nl.openminetopia.shaded.scoreboard.implementation.player.ScoreboardLibraryPlayer;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.AbstractSidebar;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.PlayerDependantLocaleSidebar;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.SidebarTask;
import nl.openminetopia.shaded.scoreboard.implementation.team.TeamManagerImpl;
import nl.openminetopia.shaded.scoreboard.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.jetbrains.annotations.NotNull;

public class LocaleListener
implements Listener {
    private final ScoreboardLibraryImpl scoreboardLibrary;

    public LocaleListener(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerLocaleChanged(PlayerLocaleChangeEvent event) {
        Player player = event.getPlayer();
        this.scoreboardLibrary.taskScheduler().runNextTick(() -> {
            ScoreboardLibraryPlayer slPlayer = this.scoreboardLibrary.getPlayer(player);
            if (slPlayer != null) {
                AbstractSidebar sidebar;
                ObjectiveManagerImpl objectiveManager;
                TeamManagerImpl teamManager = slPlayer.teamManagerQueue().current();
                if (teamManager != null) {
                    teamManager.taskQueue().add(new TeamManagerTask.ReloadPlayer(player));
                }
                if ((objectiveManager = slPlayer.objectiveManagerQueue().current()) != null) {
                    objectiveManager.taskQueue().add(new ObjectiveManagerTask.ReloadPlayer(player));
                }
                if ((sidebar = slPlayer.sidebarQueue().current()) instanceof PlayerDependantLocaleSidebar) {
                    sidebar.taskQueue().add(new SidebarTask.ReloadPlayer(player));
                }
            }
        });
    }
}

