/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.sidebar;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import nl.openminetopia.shaded.scoreboard.implementation.ScoreboardLibraryImpl;
import nl.openminetopia.shaded.scoreboard.implementation.commons.LocaleProvider;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.AbstractSidebar;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.LocaleLineHandler;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDependantLocaleSidebar
extends AbstractSidebar {
    private final Map<Player, LocaleLineHandler> playerMap = new HashMap<Player, LocaleLineHandler>();
    private final Map<Locale, LocaleLineHandler> localeMap = new HashMap<Locale, LocaleLineHandler>();

    public PlayerDependantLocaleSidebar(@NotNull ScoreboardLibraryImpl scoreboardLibrary, int maxLines, @NotNull String objectiveName) {
        super(scoreboardLibrary, maxLines, objectiveName);
    }

    @Override
    @Nullable
    public Locale locale() {
        return null;
    }

    @Override
    @NotNull
    protected Set<Player> internalPlayers() {
        return this.playerMap.keySet();
    }

    @Override
    protected void forEachLineHandler(@NotNull Consumer<LocaleLineHandler> consumer) {
        if (this.localeMap != null) {
            for (LocaleLineHandler value : this.localeMap.values()) {
                consumer.accept(value);
            }
        }
    }

    @Override
    @Nullable
    protected LocaleLineHandler addPlayer0(@NotNull Player player) {
        LocaleLineHandler sidebar = this.playerMap.get(player);
        if (sidebar != null) {
            return null;
        }
        Locale locale = LocaleProvider.locale(player);
        sidebar = this.localeMap.get(locale);
        if (sidebar != null) {
            this.playerMap.put(player, sidebar);
            return sidebar;
        }
        sidebar = new LocaleLineHandler(this, locale);
        this.localeMap.put(locale, sidebar);
        this.playerMap.put(player, sidebar);
        return sidebar;
    }

    @Override
    @Nullable
    protected LocaleLineHandler removePlayer0(@NotNull Player player) {
        if (this.playerMap == null) {
            return null;
        }
        LocaleLineHandler lineHandler = this.playerMap.remove(player);
        if (lineHandler == null) {
            return null;
        }
        if (!lineHandler.hasPlayers() && this.localeMap != null) {
            this.localeMap.remove(lineHandler.locale());
        }
        return lineHandler;
    }
}

