/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.sidebar.line;

import java.util.Collections;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import nl.openminetopia.shaded.scoreboard.implementation.commons.LineRenderingStrategy;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.AbstractSidebar;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.SidebarLineHandler;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LocaleLineHandler {
    private final AbstractSidebar sidebar;
    private final Locale locale;
    private final SidebarLineHandler[] lineHandlers;

    public LocaleLineHandler(@NotNull AbstractSidebar sidebar, @NotNull Locale locale) {
        this.sidebar = sidebar;
        this.locale = locale;
        this.lineHandlers = new SidebarLineHandler[LineRenderingStrategy.values().length];
    }

    @NotNull
    public AbstractSidebar sidebar() {
        return this.sidebar;
    }

    @NotNull
    public Locale locale() {
        return this.locale;
    }

    public boolean hasPlayers() {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null || lineHandler.players().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addPlayer(@NotNull Player player) {
        LineRenderingStrategy strategy = this.sidebar.scoreboardLibrary().packetAdapter().lineRenderingStrategy(player);
        this.lineHandler(strategy).players().add(player);
    }

    public void removePlayer(@NotNull Player player) {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null || !lineHandler.players().remove(player)) continue;
            return;
        }
    }

    @NotNull
    public SidebarLineHandler lineHandler(@NotNull LineRenderingStrategy lineType) {
        SidebarLineHandler lineHandler = this.lineHandlers[lineType.ordinal()];
        if (lineHandler == null) {
            SidebarLineHandler sidebarLineHandler = new SidebarLineHandler(lineType, this);
            this.lineHandlers[lineType.ordinal()] = sidebarLineHandler;
            lineHandler = sidebarLineHandler;
        }
        return lineHandler;
    }

    public void updateScoreFormat(int lineIndex) {
        SidebarLineHandler lineHandler = this.lineHandlers[LineRenderingStrategy.MODERN.ordinal()];
        if (lineHandler != null) {
            lineHandler.updateScore(lineIndex);
        }
    }

    public void updateLine(int lineIndex, Component renderedValue) {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null) continue;
            lineHandler.setLine(lineIndex, renderedValue);
        }
    }

    public void updateScores() {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null) continue;
            lineHandler.updateScores();
        }
    }

    public void show(Player player) {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null || !lineHandler.players().contains(player)) continue;
            lineHandler.show(Collections.singleton(player));
            return;
        }
    }

    public void hide(Player player) {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null || !lineHandler.players().contains(player)) continue;
            lineHandler.hide(Collections.singleton(player));
            return;
        }
    }

    public void hide() {
        for (SidebarLineHandler lineHandler : this.lineHandlers) {
            if (lineHandler == null) continue;
            lineHandler.hide(lineHandler.players());
        }
    }
}

