/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.sidebar.line;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import nl.openminetopia.shaded.scoreboard.implementation.commons.CollectionProvider;
import nl.openminetopia.shaded.scoreboard.implementation.commons.LineRenderingStrategy;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.GlobalLineInfo;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.LocaleLineHandler;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.locale.LegacyLocaleLine;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.locale.LocaleLine;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.locale.ModernLocaleLine;
import nl.openminetopia.shaded.scoreboard.implementation.sidebar.line.locale.PostModernLocaleLine;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SidebarLineHandler {
    private final LineRenderingStrategy strategy;
    private final LocaleLineHandler localeLineHandler;
    private final Set<Player> players = CollectionProvider.set(1);
    private final LocaleLine[] lines;

    public SidebarLineHandler(@NotNull LineRenderingStrategy strategy, @NotNull LocaleLineHandler localeLineHandler) {
        this.strategy = strategy;
        this.localeLineHandler = localeLineHandler;
        this.lines = new LocaleLine[localeLineHandler.sidebar().maxLines()];
        for (GlobalLineInfo line : localeLineHandler.sidebar().lines()) {
            Component value;
            if (line == null || (value = line.value()) == null) continue;
            this.setLine(line.line(), GlobalTranslator.render((Component)value, (Locale)localeLineHandler.locale()));
        }
    }

    @NotNull
    public LocaleLineHandler localeLineHandler() {
        return this.localeLineHandler;
    }

    @NotNull
    public Set<Player> players() {
        return this.players;
    }

    public void updateScores() {
        for (LocaleLine line : this.lines) {
            if (line == null || !line.info().updateScore()) continue;
            line.sendScore(this.players);
        }
    }

    public void updateScore(int line) {
        LocaleLine localeLine = this.lines[line];
        localeLine.sendScore(this.players);
    }

    public void setLine(int line, Component renderedLine) {
        LocaleLine localeLine = this.lines[line];
        if (renderedLine == null && localeLine == null) {
            return;
        }
        boolean newlyCreated = false;
        if (localeLine == null) {
            this.lines[line] = localeLine = this.createLine(this.strategy, this.localeLineHandler.sidebar().lines()[line]);
            newlyCreated = true;
        }
        if (renderedLine == null) {
            this.lines[line] = null;
        } else {
            localeLine.value(renderedLine);
        }
        if (renderedLine == null) {
            localeLine.hide(this.players);
        } else if (newlyCreated) {
            localeLine.resetOldPlayer();
            localeLine.show(this.players);
        } else {
            localeLine.updateTeam();
        }
    }

    public void show(Collection<Player> players) {
        for (LocaleLine line : this.lines) {
            if (line == null) continue;
            line.show(players);
        }
    }

    public void hide(Collection<Player> players) {
        for (LocaleLine line : this.lines) {
            if (line == null) continue;
            line.hide(players);
        }
    }

    @NotNull
    private LocaleLine createLine(@NotNull LineRenderingStrategy strategy, @NotNull GlobalLineInfo line) {
        switch (strategy) {
            case LEGACY: {
                return new LegacyLocaleLine(line, this);
            }
            case MODERN: {
                return new ModernLocaleLine(line, this);
            }
            case POST_MODERN: {
                return new PostModernLocaleLine(line, this);
            }
        }
        throw new IllegalArgumentException();
    }
}

