/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.team;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import nl.openminetopia.shaded.scoreboard.api.team.ScoreboardTeam;
import nl.openminetopia.shaded.scoreboard.api.team.TeamDisplay;
import nl.openminetopia.shaded.scoreboard.api.team.enums.CollisionRule;
import nl.openminetopia.shaded.scoreboard.api.team.enums.NameTagVisibility;
import nl.openminetopia.shaded.scoreboard.implementation.commons.CollectionProvider;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.ImmutableTeamProperties;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.PropertiesPacketType;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.EntriesPacketType;
import nl.openminetopia.shaded.scoreboard.implementation.packetAdapter.team.TeamDisplayPacketAdapter;
import nl.openminetopia.shaded.scoreboard.implementation.team.ScoreboardTeamImpl;
import nl.openminetopia.shaded.scoreboard.implementation.team.TeamManagerTask;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamDisplayImpl
implements TeamDisplay,
ImmutableTeamProperties<Component> {
    private final ScoreboardTeamImpl team;
    private final TeamDisplayPacketAdapter packetAdapter;
    private final Set<Player> players = CollectionProvider.set(4);
    private final List<String> entries = CollectionProvider.list(4);
    private final List<String> syncedEntries = CollectionProvider.list(4);
    private Component displayName = Component.empty();
    private Component prefix = Component.empty();
    private Component suffix = Component.empty();
    private boolean friendlyFire;
    private boolean canSeeFriendlyInvisibles;
    private NameTagVisibility nameTagVisibility = NameTagVisibility.ALWAYS;
    private CollisionRule collisionRule = CollisionRule.ALWAYS;
    private NamedTextColor playerColor = null;

    public TeamDisplayImpl(@NotNull ScoreboardTeamImpl team) {
        this.team = team;
        this.packetAdapter = team.packetAdapter().createTeamDisplayAdapter(this);
        this.packetAdapter.updateTeamPackets();
    }

    @Override
    @NotNull
    public ScoreboardTeam team() {
        return this.team;
    }

    @Override
    @NotNull
    public Collection<String> entries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    @Override
    @NotNull
    public Collection<String> syncedEntries() {
        return this.syncedEntries;
    }

    @Override
    public boolean addEntry(@NotNull String entry) {
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
            this.team.teamManager().taskQueue().add(new TeamManagerTask.AddEntries(this, Collections.singleton(entry)));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEntry(@NotNull String entry) {
        if (this.entries.remove(entry)) {
            this.team.teamManager().taskQueue().add(new TeamManagerTask.RemoveEntries(this, Collections.singleton(entry)));
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Component displayName() {
        return this.displayName;
    }

    @Override
    @NotNull
    public TeamDisplay displayName(@NotNull ComponentLike displayName) {
        Preconditions.checkNotNull((Object)displayName);
        Component component = displayName.asComponent();
        if (!Objects.equals(this.displayName, component)) {
            this.displayName = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public Component prefix() {
        return this.prefix;
    }

    @Override
    @NotNull
    public TeamDisplay prefix(@NotNull ComponentLike prefix) {
        Preconditions.checkNotNull((Object)prefix);
        Component component = prefix.asComponent();
        if (!Objects.equals(this.prefix, component)) {
            this.prefix = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public Component suffix() {
        return this.suffix;
    }

    @Override
    @NotNull
    public TeamDisplay suffix(@NotNull ComponentLike suffix) {
        Preconditions.checkNotNull((Object)suffix);
        Component component = suffix.asComponent();
        if (!Objects.equals(this.suffix, component)) {
            this.suffix = component;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    public boolean friendlyFire() {
        return this.friendlyFire;
    }

    @Override
    @NotNull
    public TeamDisplay friendlyFire(boolean friendlyFire) {
        if (this.friendlyFire != friendlyFire) {
            this.friendlyFire = friendlyFire;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    public boolean canSeeFriendlyInvisibles() {
        return this.canSeeFriendlyInvisibles;
    }

    @Override
    @NotNull
    public TeamDisplay canSeeFriendlyInvisibles(boolean canSeeFriendlyInvisibles) {
        if (this.canSeeFriendlyInvisibles != canSeeFriendlyInvisibles) {
            this.canSeeFriendlyInvisibles = canSeeFriendlyInvisibles;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public NameTagVisibility nameTagVisibility() {
        return this.nameTagVisibility;
    }

    @Override
    @NotNull
    public TeamDisplay nameTagVisibility(@NotNull NameTagVisibility nameTagVisibility) {
        Preconditions.checkNotNull((Object)((Object)nameTagVisibility));
        if (!Objects.equals((Object)this.nameTagVisibility, (Object)nameTagVisibility)) {
            this.nameTagVisibility = nameTagVisibility;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @NotNull
    public CollisionRule collisionRule() {
        return this.collisionRule;
    }

    @Override
    @NotNull
    public TeamDisplay collisionRule(@NotNull CollisionRule collisionRule) {
        Preconditions.checkNotNull((Object)((Object)collisionRule));
        if (!Objects.equals((Object)this.collisionRule, (Object)collisionRule)) {
            this.collisionRule = collisionRule;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    @Nullable
    public NamedTextColor playerColor() {
        return this.playerColor;
    }

    @Override
    @NotNull
    public TeamDisplay playerColor(@Nullable NamedTextColor playerColor) {
        if (!Objects.equals(this.playerColor, playerColor)) {
            this.playerColor = playerColor;
            this.scheduleUpdate();
        }
        return this;
    }

    @Override
    public void refresh() {
        this.scheduleUpdate();
    }

    @NotNull
    public TeamDisplayPacketAdapter packetAdapter() {
        return this.packetAdapter;
    }

    @NotNull
    public Set<Player> players() {
        return this.players;
    }

    public void handleUpdateDisplay() {
        this.packetAdapter.updateTeamPackets();
        this.packetAdapter().sendProperties(PropertiesPacketType.UPDATE, this.players());
    }

    public void handleAddEntries(@NotNull Collection<String> newEntries) {
        this.packetAdapter.sendEntries(EntriesPacketType.ADD, this.players(), newEntries);
        this.syncedEntries.addAll(newEntries);
        this.packetAdapter.updateTeamPackets();
    }

    public void handleRemoveEntries(@NotNull Collection<String> oldEntries) {
        this.packetAdapter.sendEntries(EntriesPacketType.REMOVE, this.players(), oldEntries);
        this.syncedEntries.removeAll(oldEntries);
        this.packetAdapter.updateTeamPackets();
    }

    private void scheduleUpdate() {
        Queue<TeamManagerTask> taskQueue = this.team.teamManager().taskQueue();
        TeamManagerTask lastTask = taskQueue.peek();
        if (lastTask instanceof TeamManagerTask.UpdateTeamDisplay && ((TeamManagerTask.UpdateTeamDisplay)lastTask).teamDisplay() == this) {
            return;
        }
        taskQueue.add(new TeamManagerTask.UpdateTeamDisplay(this));
    }
}

