/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.shaded.scoreboard.implementation.team;

import java.util.Iterator;
import java.util.logging.Level;
import nl.openminetopia.shaded.scoreboard.implementation.ScoreboardLibraryImpl;
import nl.openminetopia.shaded.scoreboard.implementation.scheduler.RunningTask;
import nl.openminetopia.shaded.scoreboard.implementation.team.TeamManagerImpl;
import org.jetbrains.annotations.NotNull;

public class TeamUpdaterTask
implements Runnable {
    private final ScoreboardLibraryImpl scoreboardLibrary;
    private final RunningTask task;
    private final Object lock = new Object();

    public TeamUpdaterTask(@NotNull ScoreboardLibraryImpl scoreboardLibrary) {
        this.scoreboardLibrary = scoreboardLibrary;
        this.task = scoreboardLibrary.taskScheduler().runEveryTick(this);
    }

    @NotNull
    public RunningTask task() {
        return this.task;
    }

    @NotNull
    public Object lock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<TeamManagerImpl> iterator = this.scoreboardLibrary.teamManagers().iterator();
            while (iterator.hasNext()) {
                boolean result;
                TeamManagerImpl teamManager = iterator.next();
                try {
                    result = teamManager.tick();
                }
                catch (Exception e) {
                    this.scoreboardLibrary.plugin().getLogger().log(Level.WARNING, "an error occurred while updating a TeamManager instance", e);
                    continue;
                }
                if (result) continue;
                iterator.remove();
            }
        }
    }
}

