/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.places.objects.MTPlace;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.color.enums.OwnableColorType;
import nl.openminetopia.modules.currencies.CurrencyModule;
import nl.openminetopia.modules.currencies.models.CurrencyModel;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.fitness.models.FitnessStatisticModel;
import nl.openminetopia.modules.places.models.WorldModel;
import nl.openminetopia.modules.police.utils.BalaclavaUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class ChatUtils {
    private static final MiniMessage MM = MiniMessage.miniMessage();
    private static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter TIME_FMT = DateTimeFormatter.ofPattern("HH:mm");

    private static String stripSectionCodes(String s) {
        int n = s.length();
        StringBuilder out = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\u00a7' && i + 1 < n) {
                ++i;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static Component color(String message) {
        String noLegacy = ChatUtils.stripSectionCodes(message);
        return MM.deserialize((Object)noLegacy).decoration(TextDecoration.ITALIC, false);
    }

    private static String nowDate() {
        return LocalDate.now().format(DATE_FMT);
    }

    private static String nowTime() {
        return LocalTime.now().format(TIME_FMT);
    }

    public static Component format(MinetopiaPlayer mtp, String template) {
        BankAccountModel account;
        List<FitnessStatisticModel> stats;
        Player player = mtp.getBukkit().getPlayer();
        if (player == null) {
            return Component.empty();
        }
        SpigotModuleManager<OpenMinetopia> modules = OpenMinetopia.getModuleManager();
        CurrencyModule currencyModule = modules.get(CurrencyModule.class);
        FitnessModule fitnessModule = null;
        if (!OpenMinetopia.getDefaultConfiguration().isModuleDisabled(FitnessModule.class)) {
            fitnessModule = modules.get(FitnessModule.class);
        }
        BankingModule bankingModule = modules.get(BankingModule.class);
        boolean balaclava = BalaclavaUtils.isWearingBalaclava(player);
        String displayName = balaclava ? "<obf>Balaclava</obf><reset>" : ChatUtils.stripMiniMessage(player.displayName());
        String namePlain = balaclava ? "<obf>Balaclava</obf><reset>" : player.getName();
        int levelUps = mtp.getCalculatedLevel() - mtp.getLevel();
        String msg = template;
        msg = msg.replace("<player>", namePlain).replace("<level_color>", mtp.getActiveColor(OwnableColorType.LEVEL).color()).replace("<level>", Integer.toString(mtp.getLevel())).replace("<calculated_level>", Integer.toString(mtp.getCalculatedLevel())).replace("<levelups>", (CharSequence)(levelUps == 0 ? "<gold>0" : (levelUps > 0 ? "<green>+" + levelUps : "<red>" + levelUps))).replace("<prefix_color>", mtp.getActiveColor(OwnableColorType.PREFIX).color()).replace("<prefix>", mtp.getActivePrefix().getPrefix()).replace("<name_color>", mtp.getActiveColor(OwnableColorType.NAME).color()).replace("<display_name>", displayName).replace("<chat_color>", mtp.getActiveColor(OwnableColorType.CHAT).color()).replace("<date>", ChatUtils.nowDate()).replace("<time>", ChatUtils.nowTime()).replace("<new_line>", "\n");
        List<CurrencyModel> list = currencyModule.getCurrencyModels().get(player.getUniqueId());
        if (list != null) {
            for (CurrencyModel c : list) {
                msg = msg.replace("<currency_" + c.getName() + ">", String.valueOf(c.getBalance()));
            }
        }
        if (mtp.isInPlace()) {
            WorldModel w = mtp.getWorld();
            MTPlace p = mtp.getPlace();
            msg = msg.replace("<world_title>", w.getTitle()).replace("<world_loadingname>", w.getLoadingName()).replace("<world_name>", w.getName()).replace("<world_color>", w.getColor()).replace("<city_title>", p.getTitle()).replace("<city_loadingname>", p.getLoadingName()).replace("<city_name>", p.getName()).replace("<temperature>", Double.toString(p.getTemperature())).replace("<city_color>", p.getColor());
        }
        if (fitnessModule != null && (stats = mtp.getFitness().getStatistics()) != null && !stats.isEmpty()) {
            msg = msg.replace("<fitness>", Integer.toString(mtp.getFitness().getTotalFitness())).replace("<max_fitness>", Integer.toString(fitnessModule.getConfiguration().getMaxFitnessLevel()));
        }
        if ((account = bankingModule.getAccountById(player.getUniqueId())) != null) {
            String formatted = bankingModule.format(account.getBalance());
            msg = msg.replace("<balance_formatted>", formatted).replace("<balance>", String.valueOf(account.getBalance()));
        }
        if (ChatUtils.hasPlaceholderAPI() && msg.indexOf(37) >= 0) {
            msg = PlaceholderAPI.setPlaceholders((Player)player, (String)msg);
        }
        return ChatUtils.color(msg);
    }

    private static boolean hasPlaceholderAPI() {
        return OpenMinetopia.getInstance().getServer().getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public static void sendMessage(Player player, String message) {
        Component component = ChatUtils.color(message.replaceFirst("\\[(title|action)]", ""));
        ChatUtils.decideMessage(player, component, message);
    }

    public static void sendMessage(CommandSender sender, String message) {
        Component component = ChatUtils.color(message.replaceFirst("\\[(title|action)]", ""));
        sender.sendMessage(component);
    }

    public static void sendFormattedMessage(MinetopiaPlayer minetopiaPlayer, String message) {
        Component component = ChatUtils.format(minetopiaPlayer, message.replaceFirst("\\[(title|action)]", ""));
        Player player = minetopiaPlayer.getBukkit().getPlayer();
        if (player == null) {
            return;
        }
        ChatUtils.decideMessage(player, component, message);
    }

    public static String stripMiniMessage(Component component) {
        return (String)MM.serialize(component);
    }

    public static String stripMiniMessage(String message) {
        return MM.stripTags(message);
    }

    public static String rawMiniMessage(Component component) {
        String message = ChatUtils.stripMiniMessage(component);
        return MiniMessage.miniMessage().stripTags(message);
    }

    private static void decideMessage(Player player, Component component, String message) {
        if (message.startsWith("[title]")) {
            player.showTitle(Title.title((Component)component, (Component)Component.empty()));
        } else if (message.startsWith("[action]")) {
            player.sendActionBar(component);
        } else {
            player.sendMessage(component);
        }
    }

    public static String componentToHex(Component component) {
        TextColor color = component.color();
        if (color == null) {
            return "#FFFFFF";
        }
        return color.asHexString();
    }

    @Generated
    private ChatUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

