/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils;

import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentDataUtil {
    @NotNull
    public static <T> ItemStack set(ItemStack itemStack, T value, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        NamespacedKey namespacedKey = PersistentDataUtil.createNamespacedKey(key);
        PersistentDataType<?, T> dataType = PersistentDataUtil.getDataType(value);
        if (dataType == null) {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
        }
        data.set(namespacedKey, dataType, value);
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static boolean contains(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        return data.has(PersistentDataUtil.createNamespacedKey(key));
    }

    @Nullable
    public static Object get(ItemStack itemStack, String key) {
        NamespacedKey namespacedKey;
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        Object result = PersistentDataUtil.getData(data, namespacedKey = PersistentDataUtil.createNamespacedKey(key), PersistentDataType.STRING);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.INTEGER);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.BOOLEAN);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.DOUBLE);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.FLOAT);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.LONG);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.BYTE);
        if (result != null) {
            return result;
        }
        result = PersistentDataUtil.getData(data, namespacedKey, PersistentDataType.SHORT);
        return result;
    }

    @Nullable
    public static String getString(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        return (String)PersistentDataUtil.getData(data, PersistentDataUtil.createNamespacedKey(key), PersistentDataType.STRING);
    }

    @Nullable
    public static Integer getInteger(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        return (Integer)PersistentDataUtil.getData(data, PersistentDataUtil.createNamespacedKey(key), PersistentDataType.INTEGER);
    }

    @Nullable
    public static Boolean getBoolean(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        return (Boolean)PersistentDataUtil.getData(data, PersistentDataUtil.createNamespacedKey(key), PersistentDataType.BOOLEAN);
    }

    @Nullable
    public static Double getDouble(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        return (Double)PersistentDataUtil.getData(data, PersistentDataUtil.createNamespacedKey(key), PersistentDataType.DOUBLE);
    }

    @Nullable
    public static Long getLong(ItemStack itemStack, String key) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer data = itemMeta.getPersistentDataContainer();
        return (Long)PersistentDataUtil.getData(data, PersistentDataUtil.createNamespacedKey(key), PersistentDataType.LONG);
    }

    @NotNull
    private static NamespacedKey createNamespacedKey(String key) {
        return NamespacedKey.minecraft((String)key);
    }

    @Nullable
    private static <T> PersistentDataType<?, T> getDataType(T value) {
        if (value instanceof String) {
            return PersistentDataType.STRING;
        }
        if (value instanceof Integer) {
            return PersistentDataType.INTEGER;
        }
        if (value instanceof Boolean) {
            return PersistentDataType.BOOLEAN;
        }
        if (value instanceof Double) {
            return PersistentDataType.DOUBLE;
        }
        if (value instanceof Float) {
            return PersistentDataType.FLOAT;
        }
        if (value instanceof Long) {
            return PersistentDataType.LONG;
        }
        if (value instanceof Byte) {
            return PersistentDataType.BYTE;
        }
        if (value instanceof Short) {
            return PersistentDataType.SHORT;
        }
        return null;
    }

    @Nullable
    private static <T> T getData(PersistentDataContainer data, NamespacedKey key, PersistentDataType<?, T> type) {
        if (data.has(key, type)) {
            return (T)data.get(key, type);
        }
        return null;
    }

    @Generated
    private PersistentDataUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

