/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.BooleanFlag;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public final class WorldGuardUtils {
    public static ProtectedRegion getProtectedRegion(@Nonnull Location location, Predicate<Integer> priorityPredicate) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        ProtectedRegion region = null;
        if (manager != null) {
            ApplicableRegionSet fromRegions = manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location));
            region = fromRegions.getRegions().stream().filter(protectedRegion -> priorityPredicate.test(protectedRegion.getPriority())).max(Comparator.comparing(ProtectedRegion::getPriority)).orElse(null);
        }
        return region;
    }

    public static List<ProtectedRegion> getProtectedRegions(@Nonnull Location location, Predicate<Integer> priorityPredicate) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)location.getWorld()));
        if (manager == null) {
            return new ArrayList<ProtectedRegion>();
        }
        return manager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location)).getRegions().stream().filter(protectedRegion -> priorityPredicate.test(protectedRegion.getPriority())).toList();
    }

    public static List<ProtectedRegion> getProtectedRegions(@Nonnull World world, Predicate<Integer> priorityPredicate) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)world));
        if (manager == null) {
            return new ArrayList<ProtectedRegion>();
        }
        return manager.getRegions().values().stream().filter(protectedRegion -> priorityPredicate.test(protectedRegion.getPriority())).toList();
    }

    public static List<ProtectedRegion> getProtectedRegions(Predicate<Integer> priorityPredicate) {
        ArrayList<ProtectedRegion> protectedRegions = new ArrayList<ProtectedRegion>();
        for (World world : Bukkit.getWorlds()) {
            protectedRegions.addAll(WorldGuardUtils.getProtectedRegions(world, priorityPredicate));
        }
        return protectedRegions;
    }

    public static int getOwnedRegions(Player player) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)player.getWorld()));
        if (manager == null) {
            return 0;
        }
        return (int)manager.getRegions().values().stream().filter(protectedRegion -> protectedRegion.isOwner(WorldGuardPlugin.inst().wrapPlayer(player))).count();
    }

    public static boolean isRegionOwner(ProtectedRegion protectedRegion, Player player) {
        return protectedRegion != null && protectedRegion.isOwner(WorldGuardPlugin.inst().wrapPlayer(player));
    }

    public static boolean isRegionMember(ProtectedRegion protectedRegion, Player player) {
        return protectedRegion != null && protectedRegion.isMember(WorldGuardPlugin.inst().wrapPlayer(player));
    }

    public static boolean isRegionOwnerOrMember(ProtectedRegion protectedRegion, Player player) {
        return protectedRegion != null && (protectedRegion.isOwner(WorldGuardPlugin.inst().wrapPlayer(player)) || protectedRegion.isMember(WorldGuardPlugin.inst().wrapPlayer(player)));
    }

    public static List<String> getRegionOwners(ProtectedRegion protectedRegion) {
        if (protectedRegion == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> owners = new ArrayList<String>();
        for (UUID uuid : protectedRegion.getOwners().getUniqueIds()) {
            owners.add(Bukkit.getOfflinePlayer((UUID)uuid).getName());
        }
        if (owners.isEmpty()) {
            return new ArrayList<String>();
        }
        return owners;
    }

    public static List<String> getRegionMembers(ProtectedRegion protectedRegion) {
        if (protectedRegion == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> members = new ArrayList<String>();
        for (UUID uuid : protectedRegion.getMembers().getUniqueIds()) {
            members.add(Bukkit.getOfflinePlayer((UUID)uuid).getName());
        }
        if (members.isEmpty()) {
            return new ArrayList<String>();
        }
        return members;
    }

    public static boolean isInRegionWithFlag(ProtectedRegion protectedRegion, StringFlag stringFlag) {
        return protectedRegion != null && protectedRegion.getFlag((Flag)stringFlag) != null;
    }

    @Nullable
    public static String getRegionFlag(ProtectedRegion protectedRegion, StringFlag stringFlag) {
        if (protectedRegion != null && protectedRegion.getFlag((Flag)stringFlag) != null) {
            return (String)protectedRegion.getFlag((Flag)stringFlag);
        }
        return null;
    }

    public static boolean getRegionFlag(ProtectedRegion protectedRegion, BooleanFlag booleanFlag) {
        if (protectedRegion != null && protectedRegion.getFlag((Flag)booleanFlag) != null) {
            return Boolean.TRUE.equals(protectedRegion.getFlag((Flag)booleanFlag));
        }
        return false;
    }

    public static StringFlag registerFlag(String flagName) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            StringFlag stringFlag = new StringFlag(flagName);
            registry.register((Flag)stringFlag);
            return stringFlag;
        }
        catch (Exception e) {
            Flag existingFlag = registry.get(flagName);
            if (existingFlag instanceof StringFlag) {
                StringFlag stringFlag = (StringFlag)existingFlag;
                return stringFlag;
            }
            return null;
        }
    }

    public static DoubleFlag registerDoubleFlag(String flagName) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            DoubleFlag doubleFlag = new DoubleFlag(flagName);
            registry.register((Flag)doubleFlag);
            return doubleFlag;
        }
        catch (Exception e) {
            Flag existingFlag = registry.get(flagName);
            if (existingFlag instanceof DoubleFlag) {
                DoubleFlag doubleFlag = (DoubleFlag)existingFlag;
                return doubleFlag;
            }
            return null;
        }
    }

    public static BooleanFlag registerBooleanFlag(String flagName) {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            BooleanFlag booleanFlag = new BooleanFlag(flagName);
            registry.register((Flag)booleanFlag);
            return booleanFlag;
        }
        catch (Exception e) {
            Flag existingFlag = registry.get(flagName);
            if (existingFlag instanceof BooleanFlag) {
                BooleanFlag booleanFlag = (BooleanFlag)existingFlag;
                return booleanFlag;
            }
            return null;
        }
    }

    public static FlagRegistry getFlagRegistry() {
        return WorldGuard.getInstance().getFlagRegistry();
    }

    @Generated
    private WorldGuardUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

