/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.utils.VersionUtil;
import nl.openminetopia.utils.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.spongepowered.configurate.ConfigurationNode;

public final class ConfigUtils {
    public static List<ItemStack> loadItemMappings(ConfigurationNode itemsNode, List<ItemStack> defaultItems) {
        ArrayList<ItemStack> itemList;
        if (itemsNode.isNull()) {
            itemList = new ArrayList<ItemStack>();
            for (ItemStack itemStack : defaultItems) {
                itemList.add((ItemStack)ConfigUtils.serializeItemStack(itemStack));
            }
            itemsNode.set(itemList);
        }
        itemList = new ArrayList();
        for (ConfigurationNode val2 : itemsNode.childrenList()) {
            ItemStack item = ConfigUtils.deserializeItemStack(val2);
            if (item == null) continue;
            itemList.add(item);
        }
        return itemList;
    }

    public static Map<Object, Object> serializeItemStack(ItemStack itemStack) {
        HashMap<Object, Object> itemMap = new HashMap<Object, Object>();
        try {
            int damage;
            itemMap.put("type", itemStack.getType().name());
            int customModelData = itemStack.getItemMeta().hasCustomModelData() ? itemStack.getItemMeta().getCustomModelData() : -1;
            itemMap.put("custom-model-data", customModelData);
            Damageable damageable = (Damageable)itemStack.getItemMeta();
            int n = damage = damageable.hasDamage() ? damageable.getDamage() : -1;
            if (damage != -1) {
                itemMap.put("damage", damage);
            }
            if (VersionUtil.isCompatible("1.21.4") && itemStack.getItemMeta().hasItemModel() && itemStack.getItemMeta().getItemModel() != null) {
                itemMap.put("item-model", itemStack.getItemMeta().getItemModel().toString());
            }
        }
        catch (Exception e) {
            OpenMinetopia.getInstance().getLogger().warning("Failed to serialize item: " + itemStack.getType().name());
        }
        return itemMap;
    }

    public static ItemStack deserializeItemStack(ConfigurationNode val2) {
        String typeName = val2.node(new Object[]{"type"}).getString();
        if (typeName == null) {
            return null;
        }
        Material itemMaterial = Material.matchMaterial((String)typeName);
        if (itemMaterial == null) {
            return null;
        }
        int customModelData = val2.node(new Object[]{"custom-model-data"}).getInt(-1);
        int damage = val2.node(new Object[]{"damage"}).getInt(-1);
        String itemModel = val2.node(new Object[]{"item-model"}).getString("");
        ItemBuilder itemBuilder = new ItemBuilder(itemMaterial);
        if (customModelData != -1) {
            itemBuilder.setCustomModelData(customModelData);
        }
        if (damage != -1) {
            itemBuilder.setDamage(damage);
        }
        if (VersionUtil.isCompatible("1.21.4") && !itemModel.isEmpty()) {
            itemBuilder.setItemModel(itemModel);
        }
        return itemBuilder.toItemStack();
    }

    public static List<PotionEffect> loadEffectMappings(ConfigurationNode effectsNode, List<PotionEffect> defaultEffects) {
        if (effectsNode.isNull()) {
            defaultEffects.forEach(effect -> {
                NamespacedKey effectKey = effect.getType().getKey();
                PotionEffectType potionEffectType = (PotionEffectType)Registry.EFFECT.get(effectKey);
                if (potionEffectType == null) {
                    OpenMinetopia.getInstance().getLogger().warning("Invalid potion effect: " + String.valueOf(effectKey));
                    return;
                }
                String effectName = potionEffectType.getKey().getKey().toLowerCase();
                ConfigurationNode effectNode = effectsNode.node(new Object[]{effectName});
                int amplifier = effect.getAmplifier();
                int duration = effect.getDuration();
                try {
                    effectNode.node(new Object[]{"amplifier"}).set((Object)amplifier);
                    effectNode.node(new Object[]{"duration"}).set((Object)duration);
                }
                catch (Exception e) {
                    OpenMinetopia.getInstance().getLogger().warning("Failed to load effect: " + effectName);
                }
            });
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        effectsNode.childrenMap().forEach((key, val2) -> {
            String effectName = key.toString().toLowerCase();
            PotionEffectType potionEffectType = (PotionEffectType)Registry.EFFECT.get(NamespacedKey.minecraft((String)effectName));
            if (potionEffectType == null) {
                OpenMinetopia.getInstance().getLogger().warning("Invalid potion effect: " + effectName);
                return;
            }
            int amplifier = val2.node(new Object[]{"amplifier"}).getInt(0);
            int duration = val2.node(new Object[]{"duration"}).getInt(600);
            potionEffects.add(new PotionEffect(potionEffectType, duration, amplifier));
        });
        return potionEffects;
    }

    @Generated
    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

