/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import org.apache.commons.io.FileUtils;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public abstract class ConfigurateConfig {
    protected final YamlConfigurationLoader loader;
    protected ConfigurationNode rootNode;

    public ConfigurateConfig(File file, String name, String def, boolean mergeDefaults) {
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.toPath().resolve(name))).indent(2).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESET)).build();
        if (def != null && !def.isEmpty()) {
            this.defaultConfig(file, name, def, mergeDefaults);
        }
        try {
            this.rootNode = this.loader.load();
        }
        catch (IOException e) {
            OpenMinetopia.getInstance().getLogger().warning("An error occurred while loading this configuration: " + e.getMessage());
        }
    }

    public void saveConfiguration() {
        try {
            this.loader.save(this.rootNode);
        }
        catch (Exception e) {
            OpenMinetopia.getInstance().getLogger().warning("Unable to save your messages configuration! Sorry! " + e.getMessage());
        }
    }

    private void defaultConfig(File file, String name, String def, boolean mergeDefaults) {
        File config = new File(file, name);
        if (!config.exists()) {
            InputStream resourceStream = OpenMinetopia.class.getResourceAsStream("/" + def);
            if (resourceStream == null) {
                OpenMinetopia.getInstance().getLogger().warning("Could not find def resource: " + def);
                return;
            }
            FileUtils.copyInputStreamToFile((InputStream)resourceStream, (File)config);
        } else if (mergeDefaults) {
            InputStream resourceStream = OpenMinetopia.class.getResourceAsStream("/" + def);
            if (resourceStream == null) {
                OpenMinetopia.getInstance().getLogger().warning("Could not find def resource for merging: " + def);
                return;
            }
            YamlConfigurationLoader defaultLoader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().source(() -> new BufferedReader(new InputStreamReader(resourceStream)))).indent(2).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESET)).build();
            ConfigurationNode defaultNode = defaultLoader.load();
            if (this.rootNode == null) {
                this.rootNode = this.loader.load();
            }
            this.mergeNodes(this.rootNode, defaultNode);
            this.saveConfiguration();
        }
    }

    private void mergeNodes(ConfigurationNode target, ConfigurationNode source) {
        for (Map.Entry entry : source.childrenMap().entrySet()) {
            Object key = entry.getKey();
            ConfigurationNode sourceChild = (ConfigurationNode)entry.getValue();
            if (!target.hasChild(new Object[]{key})) {
                target.node(new Object[]{key}).set((Object)sourceChild);
                continue;
            }
            if (sourceChild.isNull()) continue;
            this.mergeNodes(target.node(new Object[]{key}), sourceChild);
        }
    }

    @Generated
    public YamlConfigurationLoader getLoader() {
        return this.loader;
    }

    @Generated
    public ConfigurationNode getRootNode() {
        return this.rootNode;
    }
}

