/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils.input;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ChatInputHandler
implements Listener {
    private final Map<UUID, InputSession> inputSessions = new HashMap<UUID, InputSession>();

    public void waitForInput(Player player, Consumer<String> responseHandler) {
        UUID playerId = player.getUniqueId();
        if (this.inputSessions.containsKey(playerId)) {
            Bukkit.getScheduler().cancelTask(this.inputSessions.get(playerId).timeoutTaskId());
        }
        int taskId = Bukkit.getScheduler().runTaskLater((Plugin)OpenMinetopia.getInstance(), () -> {
            InputSession session = this.inputSessions.remove(playerId);
            if (session != null) {
                ChatUtils.sendMessage(player, "<red>Actie afgebroken, geen invoer ontvangen.");
            }
        }, 1200L).getTaskId();
        this.inputSessions.put(playerId, new InputSession(responseHandler, taskId));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        InputSession session = this.inputSessions.remove(playerId);
        if (session != null) {
            event.setCancelled(true);
            Bukkit.getScheduler().cancelTask(session.timeoutTaskId());
            session.handler().accept(ChatUtils.rawMiniMessage(event.message()));
        }
    }

    private record InputSession(Consumer<String> handler, int timeoutTaskId) {
    }
}

