/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.utils.item;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.PersistentDataUtil;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ItemBuilder {
    private ItemStack is;

    public ItemBuilder(Material m) {
        this(m, 1);
    }

    public ItemBuilder(ItemStack is) {
        this.is = is;
    }

    public ItemBuilder(Material m, int amount) {
        this.is = new ItemStack(m, amount);
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.is.clone());
    }

    public ItemBuilder setNBT(String key, Object value) {
        this.is = PersistentDataUtil.set(this.is, value, key);
        return this;
    }

    public ItemBuilder setType(Material material) {
        this.is.setType(material);
        return this;
    }

    public ItemBuilder setDamage(int damage) {
        Damageable im = (Damageable)this.is.getItemMeta();
        im.setDamage(damage);
        return this;
    }

    public ItemBuilder setItemModel(String itemModel) {
        ItemMeta im = this.is.getItemMeta();
        String[] split = itemModel.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("Item model must be in the format namespace:key");
        }
        NamespacedKey key = new NamespacedKey(split[0], split[1]);
        im.setItemModel(key);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setName(String name) {
        ItemMeta im = this.is.getItemMeta();
        im.displayName(ChatUtils.color(name).decoration(TextDecoration.ITALIC, false));
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setName(Component name) {
        ItemMeta im = this.is.getItemMeta();
        im.displayName(name.decoration(TextDecoration.ITALIC, false));
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setGlowing(boolean toggle) {
        if (toggle) {
            this.addUnsafeEnchantment(Enchantment.LUCK_OF_THE_SEA, 1);
            this.setItemFlag(ItemFlag.HIDE_ENCHANTS);
            return this;
        }
        ItemMeta im = this.is.getItemMeta();
        this.removeEnchantment(Enchantment.LUCK_OF_THE_SEA);
        im.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment ench, int level) {
        this.is.addUnsafeEnchantment(ench, level);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment ench) {
        this.is.removeEnchantment(ench);
        return this;
    }

    public ItemBuilder addEnchant(Enchantment ench, int level) {
        ItemMeta im = this.is.getItemMeta();
        im.addEnchant(ench, level, true);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> enchantments) {
        this.is.addUnsafeEnchantments(enchantments);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.is.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(Component ... lore) {
        ItemMeta im = this.is.getItemMeta();
        im.lore(Arrays.asList(lore));
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setLore(List<Component> lore) {
        ItemMeta im = this.is.getItemMeta();
        im.lore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder lore(List<Component> lore) {
        ItemMeta im = this.is.getItemMeta();
        im.lore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder removeLoreLine(Component line) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList lore = new ArrayList(im.lore());
        if (!lore.contains(line)) {
            return this;
        }
        lore.remove(line);
        im.lore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder removeLoreLine(int index) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList lore = new ArrayList(im.lore());
        if (index < 0 || index > lore.size()) {
            return this;
        }
        lore.remove(index);
        im.lore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder addLoreLine(String line) {
        this.addLoreLine(ChatUtils.color(line).decoration(TextDecoration.ITALIC, false));
        return this;
    }

    public ItemBuilder addLoreLine(Component line) {
        ItemMeta im = this.is.getItemMeta();
        ArrayList<Component> lore = new ArrayList<Component>();
        if (im.hasLore()) {
            lore = new ArrayList(im.lore());
        }
        lore.add(line);
        im.lore(lore);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta im = (LeatherArmorMeta)this.is.getItemMeta();
            im.setColor(color);
            this.is.setItemMeta((ItemMeta)im);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder setSkullOwner(Player owner) {
        SkullMeta im = (SkullMeta)this.is.getItemMeta();
        im.setOwningPlayer((OfflinePlayer)owner);
        this.is.setItemMeta((ItemMeta)im);
        return this;
    }

    public ItemBuilder setSkullOwner(OfflinePlayer owner) {
        SkullMeta im = (SkullMeta)this.is.getItemMeta();
        im.setOwningPlayer(owner);
        this.is.setItemMeta((ItemMeta)im);
        return this;
    }

    public ItemBuilder setSkullOwner(String owner) {
        SkullMeta im = (SkullMeta)this.is.getItemMeta();
        im.setOwner(owner);
        this.is.setItemMeta((ItemMeta)im);
        return this;
    }

    public ItemBuilder setItemFlag(ItemFlag itemFlag) {
        ItemMeta im = this.is.getItemMeta();
        im.addItemFlags(new ItemFlag[]{itemFlag});
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setItemFlag(ItemFlag[] itemFlag) {
        ItemMeta im = this.is.getItemMeta();
        im.addItemFlags(itemFlag);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setCustomModelData(Integer data) {
        ItemMeta im = this.is.getItemMeta();
        im.setCustomModelData(data);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setEquippableSlot(EquipmentSlot slot) {
        ItemMeta im = this.is.getItemMeta();
        EquippableComponent equippable = im.getEquippable();
        if (equippable == null) {
            return this;
        }
        equippable.setSlot(slot);
        im.setEquippable(equippable);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setEquippableModel(NamespacedKey model) {
        ItemMeta im = this.is.getItemMeta();
        EquippableComponent equippable = im.getEquippable();
        if (equippable == null) {
            return this;
        }
        equippable.setModel(model);
        im.setEquippable(equippable);
        this.is.setItemMeta(im);
        return this;
    }

    public ItemBuilder setSkinURL(String url) {
        try {
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "skull");
            PropertyMap properties = gameProfile.getProperties();
            if (properties == null) {
                return this;
            }
            String textureJSON = "{textures:{SKIN:{url:\"" + url + "\"}}}";
            String encoded = Base64Coder.encodeString((String)textureJSON);
            Property newProperty = new Property("textures", encoded);
            properties.put((Object)"textures", (Object)newProperty);
            ItemMeta skullMeta = this.is.getItemMeta();
            Method mtd = skullMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            mtd.setAccessible(true);
            mtd.invoke((Object)skullMeta, gameProfile);
            this.is.setItemMeta(skullMeta);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public ItemStack toItemStack() {
        return this.is;
    }
}

